% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridtools.R
\name{read.ascii.grid}
\alias{read.ascii.grid}
\alias{read.ascii.grid.header}
\alias{read.sgrd}
\alias{read.Rd.grid}
\alias{write.ascii.grid}
\alias{write.ascii.grid.header}
\alias{write.sgrd}
\alias{write.Rd.grid}
\title{Read/write ASCII, SAGA and Rd Grid Files}
\usage{
read.ascii.grid(file, return.header = TRUE, print = 0,
  nodata.values = c(), at.once = TRUE, na.strings = "NA")

read.ascii.grid.header(file, ...)

read.sgrd(fname, return.header = TRUE, print = 0,
  nodata.values = c(), at.once = TRUE, prec = 7, ...)

read.Rd.grid(fname, return.header = TRUE)

write.ascii.grid(data, file, header = NULL, write.header = TRUE,
  digits, hdr.digits = 10, dec = ".", georef = "corner")

write.ascii.grid.header(file, header, georef, dec = ".",
  hdr.digits = 10)

write.sgrd(data, file, header = NULL, prec = 7, hdr.prec = 10,
  georef = "corner", ...)

write.Rd.grid(data, file, header = NULL, write.header = TRUE,
  compress = TRUE)
}
\arguments{
\item{file}{file name of an ASCII grid (extension defaults to \code{.asc} if not specified), or a connection open for reading or writing, as required}

\item{return.header}{logical: should the grid header be returned (default), or just the grid data matrix? In the former case, \code{read.ascii.grid} returns a list with two components named \code{data} and \code{header}.}

\item{print}{numeric, specifying how detailed the output reporting the progress should be (currently 0 to 2, 0 being minimum output).}

\item{nodata.values}{optional numeric vector specifying nodata values to be used in addition to the nodata value specified in the grid header; nodata values are converted to \code{NA}.}

\item{at.once}{logical: if \code{TRUE}, read the whole grid with one \code{scan} command; if \code{FALSE}, read it row by row using \code{scan} with option \code{nlines=1}.}

\item{na.strings}{passed on to \code{\link[=scan]{scan()}}.}

\item{...}{\code{read.sgrd}, \code{write.sgrd}: additional arguments to be passed to \code{rsaga.geoprocessor}}

\item{fname}{file name of a grid stored as an R (\code{.Rd}) file; extension defaults to \code{.Rd}}

\item{prec}{integer: number of digits of temporary ASCII grid used for importing or exporting a SAGA grid}

\item{data}{grid data: a data matrix, or a list with components \code{data} (the grid data matrix) and \code{header} (the grid header information).}

\item{header}{optional list argument specifying the grid header information as returned by the \code{read.ascii.grid} or \code{read.ascii.grid.header} function; see Details}

\item{write.header}{logical: should the header be written with the grid data? (default: \code{TRUE})}

\item{digits}{numeric: if not missing, write data rounded to this many decimal places}

\item{hdr.digits}{numeric: see \code{hdr.prec}}

\item{dec}{character (default: \code{"."}): decimal mark used in input or output file}

\item{georef}{character: specifies whether the output grid should be  georeferenced by the \code{"center"} or \code{"corner"} of its lower left grid cell; defaults to \code{"corner"}.}

\item{hdr.prec}{numeric: write (non-integer) header data with this many decimal places; a value of 9 or higher is recommended for compatibility with SAGA GIS (default: 10)}

\item{compress}{logical: should the \code{.Rd} file written by \code{write.Rd.file} be compressed? (default: \code{TRUE})}
}
\value{
The \code{read.*} functions return either a list with components \code{data} (the grid data matrix) and \code{header} (the grid header  information, see below), if \code{return.header=TRUE}, or otherwise  just the grid data matrix \code{return.header=FALSE}.

The grid data matrix is a numeric matrix whose first column corrensponds to the first (i.e. northernmost) row of the grid. Columns run from left = West to right = East.

The header information returned by the \code{read.ascii.grid[.header]} functions (if \code{return.header=TRUE}) is a list with the following components:
\item{ncols}{Number of grid columns.}
\item{nrows}{Number of grid rows.}
\item{xllcorner}{x coordinate of the corner of the lower left grid cell.}
\item{yllcorner}{y coordinate of the corner of the lower left grid cell.}
\item{cellsize}{Single numeric value specifying the size of a grid cell or pixel in both x and y direction.}
\item{nodata_value}{Single numeric value being interpreted as \code{NA} (typically \code{-9999}.}
\item{xllcenter}{x coordinate of the center of the lower left grid cell}
\item{yllcenter}{y coordinate of the center of the lower left grid cell}
Note: The order of the components, especially of \code{?llcorner} and \code{?llcenter}, may change, depending on the order in which they appear in the grid header and on the georeferencing method (center or corner) used for the grid. The \code{?llcorner} and \code{?llcenter} attributes differ only by \code{cellsize/2}.
}
\description{
These functions provide simple interfaces for reading and writing grids from/to ASCII grids and Rd files. Grids are stored as matrices, their headers in lists.
}
\note{
\code{read.sgrd} and \code{write.sgrd} import/export grids indirectly by creating temporary ASCII grid files (this explains why \code{write.sgrd} has \code{prec} and \code{hdr.prec} arguments). Consider using \code{readGDAL} and \link[rgdal:readGDAL]{writeGDAL()} in package \code{rgdal} instead, which are likely more efficient but may require coercion of your gridded data to/from a \code{Spatial...DataFrame-class}.

The \code{read.Rd.grid} and \code{write.Rd.grid} functions use the \code{load} and \code{save} commands to store a grid. The variable name used is \code{data}, which is either a numeric matrix or a list with components \code{data} (the grid data matrix) and \code{header} (the grid header information).
}
\seealso{
\code{readGDAL} and \link[rgdal:readGDAL]{writeGDAL()} in package \code{rgdal}, and \code{readAsciiGrid} and \code{writeAsciiGrid} in package \code{maptools}
}
\author{
Alexander Brenning
}
\keyword{file}
\keyword{interface}
\keyword{spatial}
