% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaleRR.R
\name{rescaleRR}
\alias{rescaleRR}
\title{Rescaling phylogenetic trees}
\usage{
rescaleRR(tree,RR=NULL,height=NULL,trend=NULL,delta=NULL,kappa=NULL,lambda=NULL)
}
\arguments{
\item{tree}{the phylogenetic tree to be rescaled.}

\item{RR}{is the output of \code{RRphylo} performed on \code{tree}. If this
parameter is indicated, the tree branches are rescaled according to
branch-wise phenotypic evolutionary rates fitted by \code{\link{RRphylo}}.
When a multivariate phenotype is used, rescaling is operated on the norm-2
vector of rates.}

\item{height}{is the desired height of the tree. If this parameter is
indicated, the tree branches are rescaled to match the total \code{height}.}

\item{trend}{is a diffusion model with linear trend in rates through time.
The \code{trend} scaling is largely based on package \pkg{geiger}'s
\code{rescale.phylo} function.}

\item{delta}{if this parameter is indicated, the tree is rescaled according
to Pagel's delta transform (Pagel 1999). Nodes are pushed toward the
present for values of \code{delta} ranging between 0 and 1. The converse
applies for \code{delta} larger than 1. Negative \code{delta} values are
not allowed.}

\item{kappa}{if this parameter is indicated, the tree is rescaled according
to Pagel's kappa transform (Pagel 1999). At \code{kappa = 1} the tree is
left unmodified. Branches become increasingly closer to 1 as \code{kappa}
approaches 0, making evolution independent from branch lengths. Negative
\code{kappa} values are not allowed.}

\item{lambda}{if this parameter is indicated, the tree is rescaled according
to Pagel's lambda transform (Pagel 1999). At \code{lambda = 1} the tree is
left unmodified. The tree approaches a star phylogeny as \code{lambda}
approaches zero. \code{lambda} values larger than one are undefined
Negative \code{lambda} values are not allowed.}
}
\value{
Rescaled phylogenetic tree.
}
\description{
The function rescales all branches and leaves of the
  phylogenetic tree.
}
\examples{
\dontrun{
ape::rtree(100)->tree
phytools::fastBM(tree)->y
max(diag(vcv(tree)))->Hmax

RRphylo(tree,y,clus=0)->RRy
rescaleRR(tree,RR=RRy)->treeRR

rescaleRR(tree,height=Hmax/3)->tree_height

rescaleRR(tree,trend=5)->tree_trend

rescaleRR(tree,delta=0.5)->tree_delta05
rescaleRR(tree,delta=2)->tree_delta2

rescaleRR(tree,kappa=0.5)->tree_kappa

rescaleRR(tree,lambda=0.5)->tree_lambda
}
}
\references{
Castiglione, S., Serio, C., Piccolo, M., Mondanaro, A.,
  Melchionna, M., Di Febbraro, M., Sansalone, G., Wroe, S., & Raia, P.
  (2020). The influence of domestication, insularity and sociality on the
  tempo and mode of brain size evolution in mammals. \emph{Biological Journal
  of the Linnean Society},132: 221-231. doi:10.1093/biolinnean/blaa186

Pagel, M. (1999). Inferring the historical patterns of biological
  evolution. \emph{Nature}, 401:877-884.
}
\author{
Silvia Castiglione, Pasquale Raia
}
