% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overfitST.R
\name{overfitST}
\alias{overfitST}
\title{Testing search.trend overfit}
\usage{
overfitST(RR,y,oveRR,x1=NULL,x1.residuals=FALSE,node=NULL,cov=NULL,clus=0.5)
}
\arguments{
\item{RR}{an object produced by \code{\link{RRphylo}}.}

\item{y}{a named vector of phenotypes.}

\item{oveRR}{an object produced by applying \code{\link{overfitRR}} on the
object provided to the function as \code{RR}.}

\item{x1, node, cov}{arguments as passed to \code{\link{overfitRR}}.}

\item{x1.residuals}{as passed to \code{\link{search.trend}}. Default is
\code{FALSE}.}

\item{clus}{the proportion of clusters to be used in parallel computing. To
run the single-threaded version of \code{overfitST} set \code{clus} = 0.}
}
\value{
The function returns a 'RRphyloList' object containing:

\strong{$ST.list} a 'RRphyloList' including the results of each
  \code{\link{search.trend}} performed within \code{overfitST}.

\strong{$trend.results} a list including the percentage of
  simulations showing significant p-values for phenotypes versus age and
  absolute rates versus age regressions for the entire tree separated by
  slope sign ($tree). If one or more nodes are specified within
  \code{trend.args}, the list also includes the same results at nodes ($node)
  and the results for comparison between nodes ($comparison). For each node
  the proportion of tested trees (i.e. where the clade identity was
  preserved; always 1 if no \code{phylo.list} is supplied) is also indicated.

The output always has an attribute "Call" which returns an unevaluated call to the function.
}
\description{
Testing the robustness of \code{\link{search.trend}}
  (\cite{Castiglione et al. 2019a}) results to sampling effects and
  phylogenetic uncertainty.
}
\examples{
\dontrun{
cc<- 2/parallel::detectCores()
library(ape)

## Case 1
# load the RRphylo example dataset including Ornithodirans tree and data
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino
DataOrnithodirans$statedino->statedino

# extract Pterosaurs tree and data
extract.clade(treedino,746)->treeptero
massdino[match(treeptero$tip.label,names(massdino))]->massptero
massptero[match(treeptero$tip.label,names(massptero))]->massptero

# perform RRphylo and search.trend on body mass data
RRphylo(tree=treeptero,y=log(massptero),clus=cc)->RRptero
search.trend(RR=RRptero, y=log(massptero),node=143,clus=cc)->st2

## overfitST routine
# generate a list of subsampled and swapped phylogenies setting as node
# the clade under testing
treeptero.list<-resampleTree(RRptero$tree,s = 0.25,node=143,
                             swap.si = 0.1,swap.si2 = 0.1,nsim=10)

# test the robustness of search.trend
ofRRptero<-overfitRR(RR = RRptero,y=log(massptero),phylo.list=treeptero.list,clus=cc)
ofSTptero<-overfitST(RR=RRptero,y=log(massptero),oveRR=ofRRptero,node=143,clus=cc)


## Case 2
# load the RRphylo example dataset including Cetaceans tree and data
data("DataCetaceans")
DataCetaceans$treecet->treecet
DataCetaceans$masscet->masscet
DataCetaceans$brainmasscet->brainmasscet

# cross-reference the phylogenetic tree and body and brain mass data. Remove from
# both the tree and vector of body sizes the species whose brain size is missing
drop.tip(treecet,treecet$tip.label[-match(names(brainmasscet),
                                               treecet$tip.label)])->treecet.multi
masscet[match(treecet.multi$tip.label,names(masscet))]->masscet.multi

# peform RRphylo on the variable (body mass) to be used as additional predictor
RRphylo(tree=treecet.multi,y=masscet.multi,clus=cc)->RRmass.multi
RRmass.multi$aces[,1]->acemass.multi

# create the predictor vector: retrieve the ancestral character estimates
# of body size at internal nodes from the RR object ($aces) and collate them
# to the vector of species' body sizes to create
c(acemass.multi,masscet.multi)->x1.mass

# peform RRphylo and search.trend on brain mass by using body mass as additional predictor
RRphylo(tree=treecet.multi,y=brainmasscet,x1=x1.mass,clus=cc)->RRmulti
search.trend(RR=RRmulti, y=brainmasscet,x1=x1.mass,clus=cc)->STcet

## overfitST routine
# generate a list of subsampled and swapped phylogenies to test
treecet.list<-resampleTree(RRmulti$tree,s = 0.25,swap.si=0.1,swap.si2=0.1,nsim=10)

# test the robustness of search.trend with and without x1.residuals
ofRRcet<-overfitRR(RR = RRmulti,y=brainmasscet,phylo.list=treecet.list,clus=cc,x1 =x1.mass)
ofSTcet1<-overfitST(RR=RRmulti,y=brainmasscet,oveRR=ofRRcet,x1 =x1.mass,clus=cc)
ofSTcet2<-overfitST(RR=RRmulti,y=brainmasscet,oveRR=ofRRcet,x1 =x1.mass,x1.residuals = TRUE,clus=cc)
}
}
\references{
Castiglione, S., Tesone, G., Piccolo, M., Melchionna, M.,
  Mondanaro, A., Serio, C., Di Febbraro, M., & Raia, P. (2018). A new method
  for testing evolutionary rate variation and shifts in phenotypic evolution.
  \emph{Methods in Ecology and Evolution}, 9:
  974-983.doi:10.1111/2041-210X.12954

Castiglione, S., Serio, C., Mondanaro, A., Di Febbraro, M.,
  Profico, A., Girardi, G., & Raia, P. (2019a) Simultaneous detection of
  macroevolutionary patterns in phenotypic means and rate of change with and
  within phylogenetic trees including extinct species. \emph{PLoS ONE}, 14:
  e0210101. https://doi.org/10.1371/journal.pone.0210101
}
\seealso{
\href{../doc/overfitRR.html}{\code{overfitST} vignette} ;
  \href{../doc/search.trend.html}{\code{search.trend} vignette} ;
  \href{../doc/Alternative-trees.html}{\code{Alternative-trees} vignette}
}
\author{
Silvia Castiglione, Carmela Serio, Giorgia Girardi, Pasquale Raia
}
