% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenus.R
\name{getGenus}
\alias{getGenus}
\title{Taxonomic inspection of the tree at the genus level}
\usage{
getGenus(tree,genera=NULL)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and
fully dichotomous. Generic name and specific epithet must be separated by
'_'.}

\item{genera}{a character vector including one or more genera to focus on.
Please notice the function is case sensitive.}
}
\value{
The function returns a data-frame including the number of species,
  the most recent common ancestor of each genera (if a genus includes one
  species this is the species tip number), and
  whether the genera form monophyletic or paraphyletic clades.
}
\description{
The function returns the most recent common ancestor and the
  number of species belonging to each or some user-specified genera within
  the phylogenetic tree.
}
\examples{
DataCetaceans$treecet->treecet

getGenus(treecet)->gg1
getGenus(treecet,c("Mesoplodon","Balaenoptera"))->gg2
}
\author{
Silvia Castiglione, Pasquale Raia, Carmela Serio
}
