% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenus.R
\name{getGenus}
\alias{getGenus}
\title{Taxonomic inspection of the tree at the genus level}
\usage{
getGenus(tree,genera=NULL)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and
fully dichotomous.}

\item{genera}{a character vector including one or more genera to focus on.}
}
\value{
The function returns a data-frame including the number of species and
  the most recent common ancestor of each genera.
}
\description{
The function returns the most recent common ancestor and the
  number of species belonging to each or some user-specified genera within
  the phylogenetic tree.
}
\examples{
DataCetaceans$treecet->tree

getGenus(tree)
getGenus(tree,c("Mesoplodon","Balaenoptera"))
}
\author{
Silvia Castiglione, Pasquale Raia, Carmela Serio
}
