% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BarLev.R
\name{BarLev}
\alias{BarLev}
\title{BarLev model}
\usage{
BarLev(z,p,mu,sigma,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p}{probability of direct response}

\item{mu}{mean of the scramble variable \eqn{S}}

\item{sigma}{standard deviation of the scramble variable \eqn{S}}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the BarLev model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the BarLev model.
The function can also return the transformed variable.
The BarLev model was proposed by Bar-Lev et al. in 2004.
}
\details{
The randomized  response given by the person \eqn{i} is
\deqn{z_i=\left\{\begin{array}{lcc}
y_i & \textrm{with probability } p\\
y_iS & \textrm{with probability } 1-p\\
\end{array}
\right.}
where \eqn{S} is a scramble variable, whose mean \eqn{\mu} and standard deviation \eqn{\sigma} are known.
}
\examples{
data(BarLevData)
dat=with(BarLevData,data.frame(z,Pi))
p=0.6
mu=1
sigma=1
cl=0.95
BarLev(dat$z,p,mu,sigma,dat$Pi,"total",cl)
}
\references{
Bar-Lev S.K., Bobovitch, E., Boukai, B. (2004).
\emph{A note on randomized response models for quantitative data.}
Metrika, 60, 255-260.
}
\seealso{
\code{\link{BarLevData}}

\code{\link{ResamplingVariance}}
}
\keyword{BarLev}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

