% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MangatUB}
\alias{MangatUB}
\title{Mangat-UB model}
\usage{
MangatUB(I,J,p1,p2,t,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{I}{first vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{J}{second vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p1}{proportion of marked cards with the sensitive attribute in the second box}

\item{p2}{proportion of marked cards with the sensitive attribute in the third box}

\item{t}{probability of response to the sensitive questions without using random response in the first box}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Mangat-UB model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Mangat model (Mangat, 1992)
when the proportion of people bearing the innocuous attribute is unknown.
The function can also return the transformed variable.
The Mangat-UB model can be seen in Chaudhuri (2011, page 53).
}
\details{
In Mangat's extended scheme, three boxes containing cards are presented to the sampled person, labelled \eqn{i}. The first box contains cards marked "True" and "RR"
in proportions \eqn{t} and \eqn{1-t}, the second one contains \eqn{A} and \eqn{B}-marked cards in proportions \eqn{p_1} and \eqn{(1-p_1),(0<p_1<1)} and the third box
contains \eqn{A} and \eqn{B}-marked cards in proportions \eqn{p_2} and \eqn{1-p_2,(0<p_2<1),p_1\neq p_2}. The subject is requested to draw a card from the first box.
The sample respondent \eqn{i} is then instructed to tell the truth, using "the first box and if necessary also the second box" and next, independently, to give a second
truthful response also using "the first box and if necessary, the third box." Let \eqn{I_i} represent the first response and \eqn{J_i} the second response for
respondent \eqn{i}.

The transformed variable is \eqn{r_i=\frac{(1-p_2)I_i-(1-p_1)J_i}{p_1-p_2}} and the estimated variance is \eqn{\widehat{V}_R(r_i)=r_i(r_i-1)}.
}
\references{
Chaudhuri, A. (2011).
\emph{Randomized response and indirect questioning techniques in surveys.}
Boca Raton: Chapman and Hall, CRC Press.

Mangat, N.S. (1992).
\emph{Two stage randomized response sampling procedure using unrelated question.}
Journal of the Indian Society of Agricultural Statistics, 44, 82-87.
}
\seealso{
\code{\link{Mangat}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Mangat}
\keyword{Qualitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

