% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin.R
\name{ROI_plugin_build_inequality_constraints}
\alias{ROI_plugin_build_inequality_constraints}
\title{Build Functional Inequality Constraints}
\usage{
ROI_plugin_build_inequality_constraints(x, type = c("leq_zero", "geq_zero"))
}
\arguments{
\item{x}{an object of type \code{"OP"}.}

\item{type}{an character giving the type of the function to be returned,
possible values are \code{"leq\_zero"} and \code{"geq\_zero"}.
For more information see Details.}
}
\value{
Returns one function, which combines all the functional constraints.
}
\description{
There exist different forms of functional inequality constraints,
             this function transforms the form used in \pkg{ROI} into the
             forms commonly used by \R optimization solvers.
}
\details{
There are three types of inequality constraints commonly used in \R
\enumerate{
\item{\code{leq\_zero}:}{ \eqn{h(x) \leq 0} and}
\item{\code{geq\_zero}:}{ \eqn{h(x) \geq 0} and}
\item{\code{leq_geq\_rhs}:}{ \eqn{lhs \geq h(x) \leq rhs} .}
}
}
\note{
This function only intended for plugin authors.
}
\seealso{
Other plugin functions: \code{\link{ROI_plugin_add_status_code_to_db}},
  \code{\link{ROI_plugin_build_equality_constraints}},
  \code{\link{ROI_plugin_canonicalize_solution}},
  \code{\link{ROI_plugin_get_solver_name}},
  \code{\link{ROI_plugin_make_signature}},
  \code{\link{ROI_plugin_register_solver_control}},
  \code{\link{ROI_plugin_register_solver_method}},
  \code{\link{ROI_plugin_solution_prim}},
  \code{\link{ROI_registered_solver_control}}
}
