% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printMeasureit.R
\name{print.measureit}
\alias{print.measureit}
\title{Print \code{'measureit'} Object}
\usage{
\method{print}{measureit}(x, n = NULL, ... = NULL)
}
\arguments{
\item{x}{An object of class \code{"measureit"}, created with the function
\code{\link{measureit}}.}

\item{n}{How many rows of output is desired in the output. If NULL, then
prints all the rows. If specified, then first n rows are printed. If specified
n is bigger than the number of possible rows, then n is adjusted. If
non integer or negative, default (10 or number of possible rows,
whichever is smaller) is set. If \code{NULL}, all rows printed.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
S3 method to print object of \code{"measureit"} class
in organized way.
}
\examples{
data("Diabetes")
logistic.model <- glm(as.factor(dtest)~chol+age+bmi,
                      data = Diabetes,family = "binomial")
class <- logistic.model$y
score <- logistic.model$fitted.values
# -------------------------------------------------------------
measure <- measureit(score = score, class = class,
                     measure = c("ACC", "SENS", "FSCR"))
print(measure, n = 5)
print(measure, n = 10)




}
\seealso{
\code{\link{measureit}}
}
