% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/affine.R
\name{isAffine}
\alias{affine}
\alias{isAffine}
\alias{print.affine}
\title{Check whether an object is an affine matrix}
\usage{
isAffine(object, strict = FALSE)

\method{print}{affine}(x, ...)
}
\arguments{
\item{object}{Any R object.}

\item{strict}{If \code{TRUE}, this function just tests whether the object is
of class \code{"affine"}. Otherwise it also tests for an affine-like 4x4
matrix.}

\item{x}{An \code{"affine"} object.}

\item{...}{Additional parameters to methods. Currently unused.}
}
\value{
A logical value, which is \code{TRUE} if \code{object} appears to be
  an affine matrix.
}
\description{
This function returns a logical value indicating whether its argument is, or
resembles a 4x4 affine matrix. Affine transformations are a class of linear
transformations which preserve points, straight lines and planes, and may
consist of a combination of rotation, translation, scale and skew
operations.
}
\note{
2D affines are a subset of 3D affines, and are stored in a 4x4 matrix
  for internal consistency, even though a 3x3 matrix would suffice.
}
\author{
Jon Clayden <code@clayden.org>
}

