% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewer.R
\name{view}
\alias{view}
\alias{lyr}
\title{A basic 3D image viewer}
\usage{
view(..., point = NULL, radiological = getOption("radiologicalView",
  FALSE), interactive = base::interactive(), crosshairs = TRUE,
  labels = TRUE, infoPanel = defaultInfoPanel)

lyr(image, scale = "grey", min = NULL, max = NULL, mask = NULL)
}
\arguments{
\item{...}{One or more images, or \code{"viewLayer"} objects, to display.}

\item{point}{A numeric vector giving the location to initially centre the
view on. If crosshairs are in use, they will be placed at this point. For
3D images, this parameter also determines the planes shown in each
subview.}

\item{radiological}{Logical value. If \code{TRUE}, images will be displayed
in the radiological convention whereby the left of the image is shown on
the right; otherwise left is on the left.}

\item{interactive}{Logical value. If \code{TRUE}, the user can navigate
around the image by repeatedly clicking on a new centre point; otherwise
the view is fixed.}

\item{crosshairs}{Logical value, indicating whether crosshairs should be
shown or not.}

\item{labels}{Logical value, indicating whether orientation labels should be
shown or not. Ignored (defaulting to \code{FALSE}) if the image is 2D or
orientation information is not available.}

\item{infoPanel}{A function of three arguments, which must produce a plot
for the information panel of the view. \code{\link{defaultInfoPanel}} is
the default, which shows the labels and values of each image at the
current point. A \code{NULL} value will suppress the panel.}

\item{image}{The image being shown in this layer.}

\item{scale}{A character vector of colour values for the scale, or a single
string naming a predefined scale: \code{"grey"} or \code{"gray"} for
greyscale, \code{"heat"} for a heatmap, \code{"rainbow"} for a rainbow
scale, or any of the scales defined in the \code{shades} package (see
\code{?shades::gradient}, if that package is installed). A fixed colour
can be used by wrapping a string in a call to \code{I}. Ignored for RGB
images.}

\item{min, max}{The window minimum and maximum for the layer, i.e., the black
and white points. These are ignored for RGB images. Otherwise, if
\code{NULL}, the default, they are taken from the \code{cal_min} or
\code{cal_max} NIfTI header fields. If either is \code{NA}, the image has
no window stored in its header, or the two values are equal, then the 1st
and 99th percentiles of the data are used, with values close to zero
rounded to that extreme. If these values are still equal, the untrimmed
range of the image data is used.}

\item{mask}{A optional mask array, which may be of lower dimensionality than
the main image. If specified, this is converted to logical mode and pixels
that evaluate \code{FALSE} will be set to \code{NA} for that layer,
meaning they will not be plotted. This operation is performed last, and so
will not affect auto-windowing.}
}
\value{
\code{lyr} returns a list of class \code{"viewLayer"}, to be used
  in a view. \code{view} is called for its side-effect of showing a view.
}
\description{
This function displays one or more 2D or 3D images, with optional
click-to-navigate interactivity.
}
\note{
Because of the way R's main run-loop interacts with graphics, it will
  not be possible to issue further commands to the terminal while
  interactive mode is enabled. Instructions for leaving this mode are shown
  by the default info panel; see also \code{\link{locator}}, which is the
  underlying core function.
}
\examples{
im <- readNifti(system.file("extdata", "example.nii.gz", package="RNifti"))
view(im, interactive=FALSE)
view(lyr(im, max=800), interactive=FALSE)
view(lyr(im, mask=im<800), interactive=FALSE)

}
\seealso{
\code{\link{defaultInfoPanel}}, \code{\link{orientation}},
  \code{\link{locator}}
}
\author{
Jon Clayden <code@clayden.org>
}
