% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{$.niftiImage}
\alias{$.niftiImage}
\alias{$<-.niftiImage}
\title{Access to metadata elements}
\usage{
\method{$}{niftiImage}(x, name)

\method{$}{niftiImage}(x, name) <- value
}
\arguments{
\item{x}{A \code{"niftiImage"} object, internal or otherwise.}

\item{name}{A string naming the field required.}

\item{value}{A new value for the field.}
}
\description{
These methods provide shorthand access to metadata elements from the NIfTI
header corresponding to an image. The extraction version returns the
corresponding element from the result of \code{niftiHeader}, while the
replacement version calls \code{asNifti} to replace it.
}
\examples{
im <- readNifti(system.file("extdata", "example.nii.gz", package="RNifti"))
print(im$descrip)

}
\seealso{
\code{\link{niftiHeader}}, \code{\link{asNifti}}
}
\author{
Jon Clayden <code@clayden.org>
}
