% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dropLabel.R
\name{dropLabel}
\alias{dropLabel}
\title{Node Labels}
\usage{
dropLabel(node, ..., all = FALSE)
}
\arguments{
\item{node}{A node object.}

\item{...}{A character vector.}

\item{all}{A logical constant. If \code{TRUE}, drop all labels from the node.}
}
\description{
Drop the specified label(s) from a node.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, c("Person", "Student"), name = "Bob")

dropLabel(alice, "Person")
dropLabel(bob, all = TRUE)

alice
bob
}
}
\seealso{
\code{\link{addLabel}}, \code{\link{getLabel}}
}

