% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addIndex.R
\name{addIndex}
\alias{addIndex}
\title{Indexes}
\usage{
addIndex(graph, label, key)
}
\arguments{
\item{graph}{A graph object.}

\item{label}{A character string.}

\item{key}{A character string.}
}
\description{
Add an index to a node label and property key.
}
\details{
An index already exists for any (label, key) pair that has a uniqueness constraint applied.
Attempting to add an index where a uniqueness constraint already exists results in an error.
Use \code{\link{getConstraint}} to view any pre-existing uniqueness constraints.
If a uniqueness constraint already exists for the (label, key) pair, then it must be true that the index exists as well; adding an index is unnecessary.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

createNode(graph, "Person", name="Alice", status="Employed")

addIndex(graph, "Person", "status")
}
}
\seealso{
\code{\link{getIndex}}, \code{\link{dropIndex}}
}

