# RNRCS
Public repository for the RNRCS package, which pulls data from NRCS for use in R.

## How it works 
This package relies on calling the NRCS AWDB API for data, site metadata and network metadata. When pulling data the package builds an API link to CSV data for the requested site, for all elements (measurement types) reported at the site. The CSV data are then cleaned, and columns of missing data are removed. More information about the underlying API can be found [here](https://www.wcc.nrcs.usda.gov/web_service/AWDB_Web_Service_Reference.htm).  

Some returned results for data and metadata are large, so the package may return timeout errors on slow connections. If this happens, break your request down into smaller chunks (month by month data calls, for example).

To find the site info required for getting data, use the `grabNRCS.meta` or `grabNRCS.elements` function in the package. Map based options for finding site information also exist; it is strongly recommended you use the R package [**metScanR**](https://cflagg.github.io/metScanR/) (available on CRAN), or the [NRCS's mapping service](https://www.wcc.nrcs.usda.gov/webmap_beta/index.html). 

## What is the NRCS/AWDB?
The NRCS is the [**Natural Resources Conservation Service**](https://www.wcc.nrcs.usda.gov), a branch of the U.S. Department of Agriculture. It's focus is on providing technical information to ranchers, farmers, and other land owners (primarily in the western United States). However, as the name implies it also has a broader mission of protecting reources such as soil and water. As such, the NRCS collects and hosts a wide array of environmental data. A large portion of the NRCS' data is stored in the **Air and Water Database** (AWDB), which also contains datasets generated by other goverment agencies, such as the Bureau of Reclamation and the U.S. Geological Survey. 

The AWDB's focus is on climate data in the Western United States, and underpins important programs like the Snow Survey and Water Supply Forecasing Programs. Some key data sets in the AWDB are:
 - Snow Depth
 - Precipitation
 - Wind Speed and Direction
 - Air Temperature
 - Humidity
 - Soil Temperature
 - Soil Moisture
 - Streamflow
 - Reservoir Level

## What Data Can I Get With RNRCS?
Currently, the package pulls data from the BOR, SCAN, SNOTEL and SNOLITE networks, and the metadata from all networks within the AWDB. Data from SCAN and SNOTEL/SNOLITE networks are fetched with the `grabNRCS.data` function.

Additionally, States Bureau of Reclamation reservoir data can be fetched with the `grabBOR.data` function. Data are returned for elements like water level and storage in the reservoir.

With package version 0.2.0, a wind rose for data from SCAN sites can be generated, using `plotSCAN.windrose`. Only the site ID of a SCAN site and the start/end dates need to be input. 

## What Else is Coming in RNRCS?
In addition to support for pulling hydrologic data, we plan to implement some simple tools for visualizing the returned data. These tools will include:
- A hydrograph plotting function, for a given site and water year
- Graphical profiles of soil temperature and moisture
- Station comparison tools, for validating data
- Pulling Soil Survey data from NCSS
