/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg.abstracts;

import de.hzi.infg.RInterface;
import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.EFetchInterface;
import de.hzi.infg.interfaces.TypeInterface;
import de.hzi.infg.utilities.Utils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.xml.sax.SAXException;

public abstract class EFetch
implements EFetchInterface {
    protected static String GET_NAME;
    protected static String SET_NAME;
    protected Set<String> operationParameter;
    protected Map<String, String> requestParameter;
    private HttpTransportProperties.ProxyProperties proxyProperties;
    private boolean useProxy = false;
    protected HashMap<String, Object> resultMap;
    protected Object result;

    @Override
    public String[] getParameter() {
        Class<?> resClazz = this.result.getClass();
        return Utils.getParameter(resClazz);
    }

    @Override
    public String[] getParameterByName(String parameter) throws ParameterNotFoundException {
        Object tmpObj = this.resultMap.get(parameter.toLowerCase());
        if (!this.resultMap.containsKey(parameter.toLowerCase())) {
            throw new ParameterNotFoundException("The parameter \"" + parameter + "\" has no further parameters to get.");
        }
        if (tmpObj instanceof String) {
            String[] tmp = new String[]{tmpObj.toString()};
            return tmp;
        }
        if (tmpObj == null) {
            String[] tmpReturn = new String[]{"empty"};
            return tmpReturn;
        }
        Map<String, Object> tmpParaMap = ((TypeInterface)tmpObj).getParametersMap();
        return tmpParaMap.keySet().toArray(new String[tmpParaMap.keySet().size()]);
    }

    @Override
    public Map<String, Object> getResultMap() throws NoResultSoFarException {
        if (this.result == null) {
            throw new NoResultSoFarException("There are no results to get.");
        }
        return this.resultMap;
    }

    @Override
    public String getSimpleType(String name) throws ParameterNotFoundException {
        Object stringToReturn = null;
        if (this.resultMap.containsKey(name) && (stringToReturn = this.resultMap.get(name)) == null) {
            stringToReturn = "empty";
        }
        if (stringToReturn == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (!(stringToReturn instanceof String)) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is a complex type.");
        }
        return (String)stringToReturn;
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        Object firstObject = null;
        if (this.resultMap.containsKey(name) && (firstObject = this.resultMap.get(name.toLowerCase())) == null) {
            String[] tmpAr = new String[]{"empty"};
            return tmpAr;
        }
        if (firstObject == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (firstObject instanceof String) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not a complex type.");
        }
        ArrayList<String> listToReturn = new ArrayList<String>();
        String firstEntry = name;
        String values = "";
        Stack<String> ss = new Stack<String>();
        ss.push(name);
        values = Utils.recStructureBuildEFetch(values, firstObject, new Stack<String>(), ss, false, 0);
        boolean xmlErrorOccured = false;
        if (RInterface.TIDY_XML) {
            String tidyValues = "";
            try {
                tidyValues = Utils.tidyXml(values);
            }
            catch (ParserConfigurationException e) {
                xmlErrorOccured = true;
                e.printStackTrace();
            }
            catch (SAXException e) {
                xmlErrorOccured = true;
                e.printStackTrace();
            }
            catch (IOException e) {
                xmlErrorOccured = true;
                e.printStackTrace();
            }
            listToReturn.add(tidyValues);
        } else if (xmlErrorOccured) {
            listToReturn.add(values);
        }
        listToReturn.add(0, firstEntry);
        return listToReturn.toArray(new String[listToReturn.size()]);
    }

    protected void createResultMap(Object result) {
        if (this.resultMap.size() != 0) {
            return;
        }
        String[] tmpParName = this.getParameter();
        int i = 0;
        while (i < tmpParName.length) {
            Method getMethod = Utils.getGetMethodByName(tmpParName[i], result.getClass());
            Object obj = null;
            try {
                obj = getMethod.invoke(result, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.resultMap.put(tmpParName[i], obj);
            i += 2;
        }
    }

    protected void createOperationParameter(Class<?> reqClazz) {
        Method[] methods;
        this.operationParameter = new HashSet<String>();
        Method[] methodArray = methods = reqClazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.getName().equalsIgnoreCase("seterror") && !method.getName().equalsIgnoreCase("setnil") && method.getName().startsWith(SET_NAME)) {
                this.operationParameter.add(Utils.transformMethodName(method.getName(), SET_NAME));
            }
            ++n2;
        }
    }

    protected void setOptions(Options options) {
        options.setProperty("__CHUNKED__", (Object)"false");
        if (this.useProxy) {
            options.setProperty("PROXY", (Object)this.proxyProperties);
        }
    }

    private void checkParameter(Set<String> paraSet) throws ErrorFromWebserviceExeption {
        HashSet<String> tmpSet = new HashSet<String>();
        for (String string : this.operationParameter) {
            tmpSet.add(string);
        }
        if (paraSet.size() != tmpSet.size()) {
            throw new ErrorFromWebserviceExeption("Wrong arguments for this operation supplied.");
        }
        for (String para : paraSet) {
            if (tmpSet.contains(para.toLowerCase())) continue;
            throw new ErrorFromWebserviceExeption("Wrong arguments for this operation supplied.");
        }
    }

    @Override
    public String[] getOperationParameter() {
        return this.operationParameter.toArray(new String[this.operationParameter.size()]);
    }

    public void setRequestParameter(Map<String, String> arguments) throws ErrorFromWebserviceExeption {
        this.checkParameter(arguments.keySet());
        this.requestParameter = arguments;
    }

    public HttpTransportProperties.ProxyProperties getProxyProperties() {
        return this.proxyProperties;
    }

    public void setProxyProperties(HttpTransportProperties.ProxyProperties proxyProperties) {
        if (proxyProperties != null) {
            this.useProxy = true;
            this.proxyProperties = proxyProperties;
        }
    }

    public static String getGET_NAME() {
        return GET_NAME;
    }

    public static String getSET_NAME() {
        return SET_NAME;
    }

    public Object getResult() {
        return this.result;
    }
}

