% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestedX.R
\name{NestedX}
\alias{NestedX}
\title{Constructing the nested design sets for RNA model.}
\usage{
NestedX(n, d)
}
\arguments{
\item{n}{vector of the number of design points at each fidelity level \eqn{l}. Thus, the vector must have a positive value \eqn{n_1, n_2} or \eqn{n_1, n_2, n_3} where \eqn{n_1 > n_2 > n_3}.}

\item{d}{constant of the dimension of the design.}
}
\value{
A list containing the design at each level, i.e., \eqn{\mathcal{X}_{1}, \mathcal{X}_{2}} or \eqn{\mathcal{X}_{1}, \mathcal{X}_{2}, \mathcal{X}_{3}}.
}
\description{
The function constructs the nested design sets with two fidelity levels
\eqn{\mathcal{X}_2 \subseteq \mathcal{X}_{1}} for \code{\link{RNAmf_two_level}} or
three fidelity levels \eqn{\mathcal{X}_3 \subseteq \mathcal{X}_2 \subseteq \mathcal{X}_{1}}
for \code{\link{RNAmf_three_level}}.
}
\details{
The procedure replace the points of lower level design \eqn{\mathcal{X}_{l-1}}
to the closest points of higher level design \eqn{\mathcal{X}_{l}}.
The length of the \eqn{\mathcal{X}_{l-1}} could be larger than the user specified.
For details, see "\href{http://cran.nexr.com/web/packages/MuFiCokriging/MuFiCokriging.pdf}{\code{NestedDesign}}".
}
\examples{
### number of design points ###
n1 <- 30
n2 <- 15

### dimension of the design ###
d <- 2

### fix seed to reproduce the result ###
set.seed(1)

### generate the nested design ###
NX <- NestedX(c(n1, n2), d)

### visualize nested design ###
plot(NX[[1]], col="red", pch=1, xlab="x1", ylab="x2")
points(NX[[2]], col="blue", pch=4)

}
\references{
L. Le Gratiet and J. Garnier (2014). Recursive co-kriging model for design of computer experiments
with multiple levels of fidelity. \emph{International Journal for Uncertainty Quantification}, 4(5), 365-386;
\doi{doi:10.1615/Int.J.UncertaintyQuantification.2014006914}
}
