% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.r
\name{MStruncate}
\alias{MStruncate}
\title{Truncate capture histories for multi-state models}
\usage{
MStruncate(data, k = 5)
}
\arguments{
\item{data}{dataframe containing at least one character field named ch; can also contain frequency in numeric field freq and any other covariates.}

\item{k}{number of recapture occasions after release; new capture histories are of length k+1}
}
\value{
dataframe with field ch and freq (default to 1) and any covariates included in argument data; it also contains a factor variable
release which is the first occasion which should be used as a group variable so the begin.time can be set for each release cohort to 
maintain the original times, as shown in the example.
}
\description{
Decompose full capture history to releases followed by k recapture occasions. If a recapture occasion occurs before k
occasions, the capture history is finished at the first recapture and right padded with "." which effectively acts like a 
loss on capture. The recapture is then a new release and new capture history. If there are no recaptures within k occasions, it has a release followed by k 0's. If the release is such that adding k occasions is
greater than the length of the original capture history, then the new history is left padded with 0's. Capture histories that end
with a capture on the last occasion do not generate a new capture history because there are no possible recaptures and thus contain no
information in a CJS format MS model.  All freq and covariates are copied with newly generated truncated capture histories.
}
\examples{
\donttest{
data(mstrata)
df=MStruncate(mstrata,k=2)
dp=process.data(df,model="Multistrata",groups=c("release"),begin.time=1:max(as.numeric(df$release)))
ddl=make.design.data(dp)
table(ddl$S$release,ddl$S$time)
table(ddl$p$release,ddl$p$time)
}

}

