% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{dbConnect,MariaDBDriver-method}
\alias{dbConnect,MariaDBDriver-method}
\alias{MariaDB}
\title{Connect/disconnect to a MariaDB DBMS}
\usage{
\S4method{dbConnect}{MariaDBDriver}(
  drv,
  dbname = NULL,
  username = NULL,
  password = NULL,
  host = NULL,
  unix.socket = NULL,
  port = 0,
  client.flag = 0,
  groups = "rs-dbi",
  default.file = NULL,
  ssl.key = NULL,
  ssl.cert = NULL,
  ssl.ca = NULL,
  ssl.capath = NULL,
  ssl.cipher = NULL,
  ...,
  bigint = c("integer64", "integer", "numeric", "character"),
  timeout = 10
)

MariaDB()
}
\arguments{
\item{drv}{an object of class \linkS4class{MariaDBDriver} or
\linkS4class{MariaDBConnection}.}

\item{dbname}{string with the database name or NULL. If not NULL, the
connection sets the default database to this value.}

\item{username, password}{Username and password. If username omitted,
defaults to the current user. If password is omitted, only users
without a password can log in.}

\item{host}{string identifying the host machine running the MariaDB server or
NULL. If NULL or the string \code{"localhost"}, a connection to the local
host is assumed.}

\item{unix.socket}{(optional) string of the unix socket or named pipe.}

\item{port}{(optional) integer of the TCP/IP default port.}

\item{client.flag}{(optional) integer setting various MariaDB client flags,
see \link{Client-flags} for details.}

\item{groups}{string identifying a section in the \code{default.file} to use
for setting authentication parameters (see \code{\link[=MariaDB]{MariaDB()}}).}

\item{default.file}{string of the filename with MariaDB client options,
only relevant if \code{groups} is given. The default value depends on the
operating system (see references), on Linux and OS X the files
\verb{~/.my.cnf} and \verb{~/.mylogin.cnf} are used.}

\item{ssl.key}{(optional) string of the filename of the SSL key file to use.}

\item{ssl.cert}{(optional) string of the filename of the SSL certificate to
use.}

\item{ssl.ca}{(optional) string of the filename of an SSL certificate
authority file to use.}

\item{ssl.capath}{(optional) string of the path to a directory containing
the trusted SSL CA certificates in PEM format.}

\item{ssl.cipher}{(optional) string list of permitted ciphers to use for SSL
encryption.}

\item{...}{Unused, needed for compatibility with generic.}

\item{bigint}{The R type that 64-bit integer types should be mapped to,
default is \link[bit64:bit64-package]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{timeout}{Connection timeout, in seconds. Use \code{Inf} or a negative value
for no timeout.}
}
\description{
These methods are straight-forward implementations of the corresponding
generic functions.
}
\examples{
\dontrun{
# Connect to a MariaDB database running locally
con <- dbConnect(RMariaDB::MariaDB(), dbname = "mydb")
# Connect to a remote database with username and password
con <- dbConnect(RMariaDB::MariaDB(), host = "mydb.mycompany.com",
  user = "abc", password = "def")
# But instead of supplying the username and password in code, it's usually
# better to set up a group in your .my.cnf (usually located in your home
directory). Then it's less likely you'll inadvertently share them.
con <- dbConnect(RMariaDB::MariaDB(), group = "test")

# Always cleanup by disconnecting the database
dbDisconnect(con)
}

# All examples use the rs-dbi group by default.
if (mariadbHasDefault()) {
  con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")
  con
  dbDisconnect(con)
}
if (mariadbHasDefault()) {
# connect to a database and load some data
con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")
dbWriteTable(con, "USArrests", datasets::USArrests, temporary = TRUE)

# query
rs <- dbSendQuery(con, "SELECT * FROM USArrests")
d1 <- dbFetch(rs, n = 10)      # extract data in chunks of 10 rows
dbHasCompleted(rs)
d2 <- dbFetch(rs, n = -1)      # extract all remaining data
dbHasCompleted(rs)
dbClearResult(rs)
dbListTables(con)

# clean up
dbDisconnect(con)
}
}
\references{
Configuration files: https://mariadb.com/kb/en/library/configuring-mariadb-with-mycnf/
}
