% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DALMKL.R
\name{SpicyMKL}
\alias{SpicyMKL}
\title{DALMKL}
\usage{
SpicyMKL(K, y, loss = "hinge", C = 0.5, tolOuter = 0.01,
  tolInner = 1e-06, OuterMaxiter = 500, InnerMaxiter = 500,
  calpha = 10)
}
\arguments{
\item{K}{The multiple kernel cube (3-d array)}

\item{y}{The outome variable, must be -1/1}

\item{loss}{The loss function to be used, must be either 'hinge' or 'logistic', default to be 'hinge'}

\item{C}{tuning parameter for block one norm, default to be .5}

\item{tolOuter}{change between to iterations is smaller than this, algorithms is considered to have converged for outer loop, default to be .01}

\item{tolInner}{change between to iterations is smaller than this, algorithms is considered to have converged for inner loop, default to be .000001}

\item{OuterMaxiter}{maximum number of allowed iteratons for outer loop, default to be 500}

\item{InnerMaxiter}{maximum number of allowed iteratons for inner loop, default to be 500}

\item{calpha}{Lagrangian parameter, default to be 10}
}
\value{
b Estimated Intercept

alpha coeffiencents of the dual of MKL

weight Estimated between kernel weight

rho Estimated within kernel weight
}
\description{
This function conducts DALMKL for precomputed gramm matrices
}
\examples{
data(benchmark.data)
data.mkl=benchmark.data[[1]]
kernels=rep('radial',2)
sigma=c(2,1/20)
train.samples=sample(1:nrow(data.mkl),floor(0.7*nrow(data.mkl)),replace=FALSE)
degree=sapply(1:length(kernels), function(a) ifelse(kernels[a]=='p',2,0))
#Kernels.gen splts the data into a training and test set, and generates the desired kernel matrices.
#Here we generate two gaussisan kernel matrices with sigma hyperparameter 2 and 0.05
K=kernels.gen(data=data.mkl[,1:2],train.samples=train.samples,kernels=kernels,sigma=sigma,
degree=degree,scale=rep(0,length(kernels)))
C=0.05 #Cost parameter for DALMKL
K.train=K$K.train
K.test=K$K.test
# parameters set up
 ytr=data.mkl[train.samples,3]
#Converts list of kernel matrices in to an array with is appropriate for C++ code
 k.train=simplify2array(K.train)  
 k.test=simplify2array(K.test)
#Implement DALMKL with the hinge loss function
 spicy_svmb1n=SpicyMKL(K=k.train,y=ytr, loss='hinge',C=C)
 #Implement DALMKL with the hinge loss function
 spicy_logistic=SpicyMKL(K=k.train,y=ytr, loss='logistic',C=C)#' 
}
