% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpleMKL.Classification.R
\name{SimpleMKL.classification}
\alias{SimpleMKL.classification}
\title{Simple MKL}
\usage{
SimpleMKL.classification(k, outcome, penalty, tol = 10^(-4),
  max.iters = 1000)
}
\arguments{
\item{k}{list of Gramm matrices}

\item{outcome}{vector of binary outcome -1 and 1}

\item{penalty}{ppenalty of the smoothness of the resulting desicion rules}

\item{tol}{change between to iterations is smaller than this, algorithms is considered to have converged}

\item{max.iters}{maximum number of allowed iteratons}
}
\value{
gamma weight vector for the importnace of each kernel

alpha coeffiencents of the dual of MKL

time total amount of time to train model

max.iters Numvber of iterations to reach convergence criteria
}
\description{
This function conducts Simple MKL for precomputed gramm matrices
}
\examples{
library(kernlab)
library(caret)
library(RMKL)
#Load data
data(benchmark.data)
example.data=benchmark.data[[1]]
# Split samples into training and test sets 
training.samples=sample(1:dim(example.data)[1],floor(0.7*dim(example.data)[1]),replace=FALSE)
# Set up cost parameters and kernels 
C=100
kernels=rep('radial',3)
degree=rep(0,3)
scale=rep(0,3)
sigma=c(0,2^seq(-3:0))
K=kernels.gen(example.data[,1:2], training.samples, kernels, degree, scale, sigma)
K.train=K$K.train
SimpleMKL.classification(K.train,example.data[training.samples,3], C)
}
