% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineInterpolateMonthlytoDaily.R
\name{splineInterpolateMonthlytoDaily}
\alias{splineInterpolateMonthlytoDaily}
\title{Interpolates monthly data to daily data using \code{\link{spline}}  and preserving monthly mean values}
\usage{
splineInterpolateMonthlytoDaily(nday = 365, val = as.matrix(cbind(1 *
  (0.5:11.5) * nday/12, 2 * (0.5:11.5) * nday/12)), origin = "1961-1-1",
  first_row = 1, last_row = nday, no_spline = FALSE, no_mean = FALSE)
}
\arguments{
\item{nday}{number of days on which the daily data is requested, e.g. number of days in one year}

\item{val}{matrix containing monthly mean data}

\item{origin}{date corresponding to the first row of the returned matrix}

\item{first_row}{row corresponding the first day of time interval where montlhy mean conservation is applied}

\item{last_row}{corresponding the last day of time interval where montlhy mean conservation is applied}

\item{no_spline}{logical value. If \code{TRUE} no spline interpolation is calculated and the daily value corresponds to the monthly average value. Default is \code{FALSE}.}

\item{no_mean}{logical value. Default is \code{FALSE}. If \code{TRUE} the function output is not rescaled in order to maintain observed mean monthly values. 
@export}
}
\value{
a matrix or data frame with interpolated daily data
}
\description{
Interpolates monthly data to daily data using \code{\link{spline}}  and preserving monthly mean values
}
\author{
Emanuele Cordano, Emanuele Eccel
}
\seealso{
\code{\link{spline}},\code{\link{splineInterpolateMonthlytoDailyforSeveralYears}}
}

