/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.misc.monotone.BooleanBitMatrix;
import weka.classifiers.misc.monotone.Coordinates;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.classifiers.misc.monotone.EnumerationIterator;
import weka.classifiers.misc.monotone.NominalLossFunction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class InstancesUtil {
    public static boolean equalIgnoreClass(Instance instance, Instance instance2) {
        int n;
        int n2 = instance.numAttributes();
        int n3 = instance.classIndex();
        if (instance2.numAttributes() != n2 || n3 != instance2.classIndex()) {
            return false;
        }
        for (n = 0; n < n2 && (n == n3 || Utils.eq(instance.value(n), instance2.value(n))); ++n) {
        }
        return n == n2;
    }

    public static int containsIgnoreClass(Instances instances, Instance instance) {
        double[] dArray = instance.toDoubleArray();
        int n = instances.classIndex();
        int n2 = instances.numAttributes();
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        int n3 = 0;
        while (enumerationIterator.hasNext()) {
            int n4;
            Instance instance2 = (Instance)enumerationIterator.next();
            for (n4 = 0; n4 < n2 && (n4 == n || Utils.eq(dArray[n4], instance2.value(n4))); ++n4) {
            }
            if (n4 == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int nextOccurenceIgnoreClass(Instances instances, Instance instance, int n) {
        double[] dArray = instance.toDoubleArray();
        int n2 = instances.classIndex();
        int n3 = instances.numAttributes();
        int n4 = instances.numInstances();
        for (int i = n; i < n4; ++i) {
            int n5;
            Instance instance2 = instances.instance(i);
            for (n5 = 0; n5 < n3 && (n5 == n2 || Utils.eq(dArray[n5], instance2.value(n5))); ++n5) {
            }
            if (n5 != n3) continue;
            return i;
        }
        return -1;
    }

    public static boolean isHomogeneous(Instances instances) {
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        if (enumerationIterator.hasNext()) {
            double d = ((Instance)enumerationIterator.next()).classValue();
            while (enumerationIterator.hasNext()) {
                if (((Instance)enumerationIterator.next()).classValue() == d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean strictlySmaller(Instance instance, Instance instance2) {
        Coordinates coordinates = new Coordinates(instance);
        Coordinates coordinates2 = new Coordinates(instance2);
        return coordinates.strictlySmaller(coordinates2);
    }

    public static boolean smallerOrEqual(Instance instance, Instance instance2) {
        Coordinates coordinates = new Coordinates(instance);
        Coordinates coordinates2 = new Coordinates(instance2);
        return coordinates.smallerOrEqual(coordinates2);
    }

    public static boolean comparable(Instance instance, Instance instance2) throws IllegalArgumentException {
        Coordinates coordinates = new Coordinates(instance);
        Coordinates coordinates2 = new Coordinates(instance2);
        return coordinates.smallerOrEqual(coordinates2) || coordinates2.smallerOrEqual(coordinates);
    }

    public static boolean doubt(Instance instance, Instance instance2) {
        if (instance.classValue() == instance2.classValue()) {
            return false;
        }
        Coordinates coordinates = new Coordinates(instance);
        Coordinates coordinates2 = new Coordinates(instance2);
        return coordinates.equals(coordinates2);
    }

    public static boolean reversedPreference(Instance instance, Instance instance2) throws IllegalArgumentException {
        if (instance.classValue() == instance2.classValue()) {
            return false;
        }
        Coordinates coordinates = new Coordinates(instance);
        Coordinates coordinates2 = new Coordinates(instance2);
        if (instance.classValue() > instance2.classValue() && coordinates.strictlySmaller(coordinates2)) {
            return true;
        }
        return instance2.classValue() > instance.classValue() && coordinates2.strictlySmaller(coordinates);
    }

    public static boolean isMonotone(Instances instances) {
        int n = instances.numInstances();
        for (int i = 0; i < n; ++i) {
            Instance instance = instances.instance(i);
            for (int j = i + 1; j < n; ++j) {
                if (!InstancesUtil.doubt(instance, instances.instance(j)) && !InstancesUtil.reversedPreference(instance, instances.instance(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isQuasiMonotone(Instances instances, Instances instances2) {
        if (!InstancesUtil.isMonotone(instances)) {
            return false;
        }
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance = (Instance)enumerationIterator.next();
            EnumerationIterator enumerationIterator2 = new EnumerationIterator(instances2.enumerateInstances());
            while (enumerationIterator2.hasNext()) {
                Instance instance2 = (Instance)enumerationIterator2.next();
                if (!InstancesUtil.doubt(instance, instance2) && !InstancesUtil.reversedPreference(instance, instance2)) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] nrOfReversedPreferences(Instances instances) {
        int[] nArray = new int[3];
        int n = instances.numInstances();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = n * (n - 1) / 2;
        for (int i = 0; i < n; ++i) {
            Instance instance = instances.instance(i);
            for (int j = i + 1; j < n; ++j) {
                Instance instance2 = instances.instance(j);
                if (!InstancesUtil.comparable(instance, instance2)) continue;
                nArray[1] = nArray[1] + 1;
                if (!InstancesUtil.reversedPreference(instance, instance2)) continue;
                nArray[0] = nArray[0] + 1;
            }
        }
        return nArray;
    }

    public static int[] nrStochasticReversedPreference(Instances instances) throws IllegalArgumentException {
        Object object;
        Serializable serializable;
        if (instances.classIndex() < 0) {
            throw new IllegalArgumentException("Class is not set");
        }
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        if (instances2.numInstances() == 0) {
            throw new IllegalArgumentException("No instances with a class value!");
        }
        HashMap<Object, DiscreteEstimator> hashMap = new HashMap<Object, DiscreteEstimator>(instances2.numInstances() / 2);
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            serializable = (Instance)enumerationIterator.next();
            object = new Coordinates((Instance)serializable);
            Object object2 = (DiscreteEstimator)hashMap.get(object);
            if (object2 == null) {
                object2 = new DiscreteEstimator(instances.numClasses(), 0.0);
            }
            ((DiscreteEstimator)object2).addValue(((Instance)serializable).classValue(), ((Instance)serializable).weight());
            hashMap.put(object, (DiscreteEstimator)object2);
        }
        serializable = new HashMap(hashMap.size());
        for (Object object2 : hashMap.keySet()) {
            Serializable serializable2 = (DiscreteEstimator)hashMap.get(object2);
            serializable.put(object2, new CumulativeDiscreteDistribution((DiscreteEstimator)serializable2));
        }
        object = new int[5];
        object[0] = serializable.size();
        for (Serializable serializable2 : serializable.keySet()) {
            CumulativeDiscreteDistribution cumulativeDiscreteDistribution = (CumulativeDiscreteDistribution)serializable.get(serializable2);
            for (Coordinates coordinates : serializable.keySet()) {
                CumulativeDiscreteDistribution cumulativeDiscreteDistribution2 = (CumulativeDiscreteDistribution)serializable.get(coordinates);
                if (coordinates.equals(serializable2)) continue;
                Object object3 = object;
                object3[4] = object3[4] + true;
                if (!((Coordinates)serializable2).strictlySmaller(coordinates)) continue;
                Object object4 = object;
                object4[3] = object4[3] + true;
                if (cumulativeDiscreteDistribution.stochasticDominatedBy(cumulativeDiscreteDistribution2)) continue;
                Object object5 = object;
                object5[1] = object5[1] + true;
                if (!cumulativeDiscreteDistribution2.stochasticDominatedBy(cumulativeDiscreteDistribution)) continue;
                Object object6 = object;
                object6[2] = object6[2] + true;
            }
        }
        Object object7 = object;
        object7[4] = object7[4] / 2;
        return object;
    }

    public static int nrOfRedundant(Instances instances) {
        int n = instances.numInstances();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Instance instance = instances.instance(i);
            for (int j = i + 1; j < n; ++j) {
                Instance instance2 = instances.instance(j);
                if (instance2.classValue() != instance.classValue() || !InstancesUtil.comparable(instance, instance2)) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static double totalLoss(Classifier classifier, Instances instances, NominalLossFunction nominalLossFunction) {
        double d = 0.0;
        int n = instances.numInstances();
        for (int i = 0; i < n; ++i) {
            try {
                d += nominalLossFunction.loss(instances.instance(i).classValue(), classifier.classifyInstance(instances.instance(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public static void classifyInstances(Instances instances, Classifier classifier) throws Exception {
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance = (Instance)enumerationIterator.next();
            instance.setClassValue(classifier.classifyInstance(instance));
        }
    }

    public static BooleanBitMatrix getBitMatrix(Instances instances) {
        int n = instances.numInstances();
        BooleanBitMatrix booleanBitMatrix = new BooleanBitMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < n; ++j) {
                Instance instance2 = instances.instance(j);
                if (!InstancesUtil.strictlySmaller(instance, instance2)) continue;
                booleanBitMatrix.set(i, j);
            }
        }
        return booleanBitMatrix;
    }

    public static double numberInInterval(Instance instance, Instance instance2) throws IllegalArgumentException {
        Coordinates coordinates = new Coordinates(instance);
        Coordinates coordinates2 = new Coordinates(instance2);
        if (!coordinates.smallerOrEqual(coordinates2)) {
            throw new IllegalArgumentException("The given instances are not the bounds of an interval");
        }
        double d = 1.0;
        int n = coordinates.dimension();
        for (int i = 0; i < n; ++i) {
            d *= coordinates2.getValue(i) - coordinates.getValue(i) + 1.0;
        }
        return d;
    }

    public static double numberOfSmallerVectors(Instance instance) throws IllegalArgumentException {
        double[] dArray = InstancesUtil.toDataDouble(instance);
        double d = 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (instance.attribute(i).isNumeric()) {
                throw new IllegalArgumentException("Numeric attributes are not supported");
            }
            d *= dArray[i] + 1.0;
        }
        return d;
    }

    public static double numberOfGreaterVectors(Instance instance) throws IllegalArgumentException {
        double[] dArray = InstancesUtil.toDataDouble(instance);
        double d = 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (instance.attribute(i).isNumeric()) {
                throw new IllegalArgumentException("Numeric attributes are not supported");
            }
            d *= (double)instance.attribute(i).numValues() - dArray[i];
        }
        return d;
    }

    public static void write(Instances instances, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(instances.toString());
    }

    public static DiscreteEstimator countValues(Instances instances, int n) throws IllegalArgumentException {
        int n2 = instances.attribute(n).numValues();
        if (n2 == 0) {
            throw new IllegalArgumentException("Can't create histogram for numeric attribute");
        }
        DiscreteEstimator discreteEstimator = new DiscreteEstimator(n2, false);
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance = (Instance)enumerationIterator.next();
            if (instance.isMissing(n)) continue;
            discreteEstimator.addValue(instance.value(n), instance.weight());
        }
        return discreteEstimator;
    }

    public static Instances sampleWithoutReplacement(Instances instances, int n, Random random) {
        if (n > instances.numInstances()) {
            throw new IllegalArgumentException("Size of requested sample exceeds number of instances");
        }
        int n2 = instances.numInstances();
        int[] nArray = new int[instances.numInstances()];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        Instances instances2 = new Instances(instances, n);
        for (int i = 0; i < n; ++i) {
            int n3 = random.nextInt(n2--);
            instances2.add(instances.instance(nArray[n3]));
            InstancesUtil.swap(nArray, n3, n2);
        }
        return instances2;
    }

    private static final void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static Instances generateRandomSample(Instances instances, int n, Random random) throws IllegalArgumentException {
        int n2 = instances.numAttributes();
        double[] dArray = new double[n2];
        int n3 = instances.classIndex();
        for (int i = 0; i < n2; ++i) {
            dArray[i] = instances.attribute(i).numValues();
            if (i == n3 || dArray[i] != 0.0) continue;
            throw new IllegalArgumentException("Numeric attributes are currently not supported");
        }
        Instances instances2 = new Instances(instances, n);
        instances2.setRelationName(instances.relationName() + ".random.sample.of." + n);
        for (int i = 0; i < n; ++i) {
            instances2.add(InstancesUtil.randomSample(dArray, n3, random));
        }
        return instances2;
    }

    private static Instance randomSample(double[] dArray, int n, Random random) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            if (i == n) continue;
            dArray2[i] = random.nextInt((int)dArray[i]);
        }
        return new Instance(1.0, dArray2);
    }

    public static double[] toDataDouble(Instance instance) {
        double[] dArray = null;
        int n = instance.classIndex();
        dArray = n >= 0 ? new double[instance.numAttributes() - 1] : new double[instance.numAttributes()];
        int n2 = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == n) continue;
            dArray[n2++] = instance.value(i);
        }
        return dArray;
    }

    public static double minimalExtension(Instances instances, Instance instance) {
        return InstancesUtil.minimalExtension(instances, instance, 0.0);
    }

    public static double minimalExtension(Instances instances, Instance instance, double d) {
        double d2 = d;
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            if (!(instance2.classValue() > d2) || !InstancesUtil.smallerOrEqual(instance2, instance)) continue;
            d2 = instance2.classValue();
        }
        return d2;
    }

    public static double maximalExtension(Instances instances, Instance instance) {
        return InstancesUtil.maximalExtension(instances, instance, instances.numClasses() - 1);
    }

    public static double maximalExtension(Instances instances, Instance instance, double d) {
        double d2 = d;
        EnumerationIterator enumerationIterator = new EnumerationIterator(instances.enumerateInstances());
        while (enumerationIterator.hasNext()) {
            Instance instance2 = (Instance)enumerationIterator.next();
            if (!(instance2.classValue() < d2) || !InstancesUtil.smallerOrEqual(instance, instance2)) continue;
            d2 = instance2.classValue();
        }
        return d2;
    }
}

