% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset10}
\alias{dataset10}
\title{Marc Ruschin ROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:3, 1:8, 1:90, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:3, 1:8, 1:40, 1] , ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:40], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:40, 1], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:40, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset10", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "RUSCHIN", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:3, 1:8, 1:90, 1:2], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:3] "1" "2" "3", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:8] "1" "2" "3" "4" ..., reader labels}
}
}
\usage{
dataset10
}
\description{
This is referred to in the book as the "RUS" dataset. It consists of 90 cases, 
40 of which are diseased, the images were
acquired at three dose levels, which can be regarded as treatments.
"0" = conventional film radiographs, "1" = digitized  images viewed on monitors, Eight 
radiologists interpreted the cases using the FROC paradigm. These have been reduced to 
ROC data by using the highest ratings (the original FROC data is lost).
}
\examples{
str(dataset10)
PlotEmpiricalOperatingCharacteristics(dataset = dataset10, opChType = "ROC")$Plot


}
\references{
Ruschin M, et al. Dose dependence of mass and microcalcification 
detection in digital mammography: free response human observer studies. 
Med Phys. 2007;34:400 - 407.
}
\keyword{datasets}
