% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsFrocNhRsmModel.R
\name{SsFrocNhRsmModel}
\alias{SsFrocNhRsmModel}
\title{RSM fitted model for FROC sample size}
\usage{
SsFrocNhRsmModel(dataset, lesDistr)
}
\arguments{
\item{dataset}{The \strong{pilot} dataset object representing a NH ROC 
(or FROC) dataset.}

\item{lesDistr}{A 1D array containing the probability mass function of 
number of lesions per diseased case in the \strong{pivotal FROC} 
study.}
}
\value{
A list containing: 
   \itemize{ 
   \item \code{muMed}, the median mu parameter of the NH model. 
   \item \code{lambdaMed}, the median lambda parameter of the NH model.  
   \item \code{nuMed}, the median nu parameter of the NH model. 
   \item \code{lesDistr}, the lesion distribution 2D array. 
   \item \code{lesWghtDistr}, the lesion weight distribution 2D array. 
   \item \code{scaleFactor}, the scaling factor that multiplies 
      the ROC effect size to get wAFROC effect size.
   \item \code{R2}, the R2 of the fit.
}
}
\description{
RSM fitted model for FROC sample size
}
\details{
If dataset is FROC, it is converted to an ROC dataset. The search model 
    is used to fit each treatment-reader combination in the pilot dataset. The median 
    value for each parameter is computed and are returned by the function (3 vaalues). 
    These are used 
    to compute predicted wAFROC and ROC FOMS over a range of values of deltaMu, 
    which are fitted by a straight line constrained to pass throught the origin.
    The scaleFactor (scaling factor) and R2 are returned. The scaling factor is the value
    by which the ROC effect size must be multiplied to get the wAFROC effect size. Also 
    returned are the lesDist and lesWghtDist arrays, which are needed for computing
    FOMs. See 2nd FROC SS vignette. Equally weighted lesions is assumed.
}
\examples{
 
\donttest{
## Examples with CPU or elapsed time > 5s
## user system elapsed
## SsFrocNhRsmModel 8.102  0.023   8.135
 
## SsFrocNhRsmModel(dataset02, c(0.7, 0.2, 0.1))
## the next one should match the vignette 
## SsFrocNhRsmModel(DfExtractDataset(dataset04, trts = c(1,2)), c(0.69, 0.2, 0.11))
}

}
