% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset03}
\alias{dataset03}
\title{Franken ROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:2, 1:4, 1:100, 1], of false positives, FPs}
\item{\code{LL}}{ Ratings array [1:2, 1:4, 1:67, 1], of true positives, TPs}
\item{\code{lesionVector}}{ array [1:67], number of lesions per diseased case, all set to 1}
\item{\code{lesionID}}{ array [1:67, 1], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:67, 1], weights (or clinical importance) of lesions, all set to 1}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ [1:2] "TREAT1" "TREAT2", the treatment labels}
\item{\code{readerID}}{ [1:4] "READER_1" "READER_2" "READER_3" "READER_4", the reader labels}
}}
\usage{
dataset03
}
\description{
This is referred to in the book as the "FR" dataset. It consists of 100 cases, 
67 of which are diseased, interpreted in two treatments,
"0" = conventional film radiographs, "1" = digitized  images viewed on monitors, by four 
radiologists using the ROC paradigm. Often referred to in the ROC literature as the 
Franken-dataset, which, along the the Van Dyke dataset, has been widely used to illustrate
advances in ROC methodology.
}
\examples{
str(dataset03)
PlotEmpiricalOperatingCharacteristics(dataset = dataset03, opChType = "ROC")$Plot


}
\references{
Franken EA, et al. Evaluation of a Digital Workstation for Interpreting 
Neonatal Examinations: A Receiver Operating Characteristic Study. Investigative Radiology. 
1992;27(9):732-737.
}
\keyword{datasets}
