% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilVarComponentsOR.R
\name{UtilVarComponentsOR}
\alias{UtilVarComponentsOR}
\title{Utility for Obuchowski-Rockette variance components}
\usage{
UtilVarComponentsOR(
  dataset,
  FOM,
  FPFValue = 0.2,
  covEstMethod = "Jackknife",
  nBoots = 200
)
}
\arguments{
\item{dataset}{The dataset object}

\item{FOM}{The figure of merit}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}

\item{covEstMethod}{The covariance estimation method, "jackknife" 
(the default) or "bootstrap".}

\item{nBoots}{The number of bootstraps, defaults to 200}
}
\value{
A list object containing the variance components.
}
\description{
Utility for Obuchowski-Rockette variance components
}
\details{
The variance components are obtained using \link{StSignificanceTesting} 
    with \code{method = "ORH"}.
}
\examples{
UtilVarComponentsOR(dataset02, FOM = "Wilcoxon")$varComp

  
}
