% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSingleTreatmentRandomReader.R
\name{StSingleTreatmentRandomReader}
\alias{StSingleTreatmentRandomReader}
\title{Significance testing for single random factor}
\usage{
StSingleTreatmentRandomReader(
  dataset,
  fomNh,
  FOM,
  FPFValue = 0.2,
  alpha = 0.05
)
}
\arguments{
\item{dataset}{A single-treatment multipe-reader dataset.}

\item{fomNh}{The comparison value that the reader average FOM is compared to.}

\item{FOM}{The figure of merit, see \code{\link{UtilFigureOfMerit}}.}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}

\item{alpha}{The significance level (\code{alpha}, default 0.05) 
of the test of the null hypothesis that the reader averaged FOMs and the specified
NH value fomNh are identical.}
}
\value{
The return value is a list containing:
\itemize{
\item{\code{fom}}   {Observed reader FOMs.}
\item{\code{avgFom}}   {Average reader FOM.} 
\item{\code{CIAvgFom}}   {Confidence interval of the reader averaged FOM.}
\item{\code{vaR}}   {Reader variance term of the Obuchowski-Rockette model.}
\item{\code{cov2}}   {cov2 of the Obuchowski-Rockette model.}
\item{\code{var}}   {Error term of the Obuchowski-Rockette model.}
\item{\code{Tstat}}   {The observed value of the t-statistic.}
\item{\code{df}}   {The degrees of freedom associated with the t-statistic.}
\item{\code{pValue}}   {The p-value for rejecting the NH.}
}
}
\description{
Significance testing for datasets with multiple readers in 
   a single treatment, compare average FOM to specified NH value.
}
\details{
This function performs implements Hillis et al. 2005, Eqn. 23.
}
\examples{
## Create a single treatment ROC dataset with four readers
singleFactorData <- DfExtractDataset(dataset02, trts = 1, rdrs = seq(1,4))

## Perform single-treatment random-reader analysis
StSingleTreatmentRandomReader(singleFactorData, fomNh = 0.8, FOM = "Wilcoxon")

}
\references{
Hillis SL, Obuchowski NA, Schartz KM, Berbaum KS (2005) A comparison of the Dorfman-Berbaum-Metz and Obuchowski-Rockette methods for receiver operating characteristic (ROC) data, 
Statistics in Medicine, 24(10), 1579-607.

Hillis SL (2007) A comparison of denominator degrees of freedom methods 
for multiple observer ROC studies, Statistics in Medicine. 26:596-619.

Hillis SL (2014) A marginal mean ANOVA approach for analyzing multireader multicase radiological imaging data,
Statistics in medicine 33, 330-360.
}
