% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfFroc2Lroc.R
\name{DfFroc2Lroc}
\alias{DfFroc2Lroc}
\title{Simulates an "AUC-equivalent" LROC dataset from an FROC dataset}
\usage{
DfFroc2Lroc(dataset)
}
\arguments{
\item{dataset}{The FROC dataset to be converted to LROC.}
}
\value{
The equivalent LROC dataset
}
\description{
Simulates a multiple-treatment multiple-reader "AUC-equivalent" 
   LROC dataset from a supplied FROC dataset.
}
\details{
The FROC paradigm can have 0 or more marks per case. However, 
   LROC is restricted to \bold{exactly one mark per case}. For the NL array 
   of the LROC data, for non-disesed cases, the \bold{highest} rating of the 
   FROC marks, or -Inf if there are no marks, is copied to case index 
   k1 = 1 to k1 = K1 of the LROC dataset. For each diseased case, if the 
   max LL rating exceeds the max NL rating, then the max LL rating is copied 
   to the LLCl array, otherwise the max NL rating is copied to the LLIl array. 
   The max NL rating on each diseased case is then set to -Inf (since the LROC
   paradigm only allows one mark. The equivalent FROC dataset has the same 
   HrAuc as the original LROC dataset. See example. The main use of this 
   function is to test the Significance testing functions using MRMC LROC 
   datasets, which I currently don't have.
}
\examples{

lrocDataset <- DfFroc2Lroc(dataset05)
frocHrAuc <- UtilFigureOfMerit(dataset05, FOM = "HrAuc")   
lrocWilcoxonAuc <- UtilFigureOfMerit(lrocDataset, FOM = "Wilcoxon")

}
