% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitBinormalRoc.R
\name{FitBinormalRoc}
\alias{FitBinormalRoc}
\title{Fit the binormal model to selected treatment and reader in an ROC dataset}
\usage{
FitBinormalRoc(dataset, trt = 1, rdr = 1)
}
\arguments{
\item{dataset}{The ROC dataset}

\item{trt}{The desired treatment, default is 1}

\item{rdr}{The desired reader, default is 1}
}
\value{
The returned value is a list with the following elements:

\item{a}{The mean of the diseased distribution; 
   the non-diseased distribution is assumed to have zero mean}

\item{b}{The standard deviation of the non-diseased 
   distribution. The diseased distribution is assumed to have 
   unit standard deviation}

\item{zetas}{The binormal model cutoffs, zetas or thresholds}

\item{AUC}{The binormal model fitted ROC-AUC}

\item{StdAUC}{The standard deviation of AUC}

\item{NLLIni}{The initial value of negative LL}

\item{NLLFin}{The final value of negative LL}

\item{ChisqrFitStats}{The chisquare goodness of fit results}

\item{covMat}{The covariance matrix of the parameters}

\item{fittedPlot}{A \pkg{ggplot2} object containing the 
   fitted operating characteristic along with the empirical operating 
   points. Use \code{print()} to display the object}
}
\description{
Fit the binormal model-predicted ROC curve for an individual dataset. 
   This is the R equivalent of ROCFIT or RSCORE
}
\details{
In the binormal model ratings (more accurately the latent decision variables) 
   from diseased cases are sampled from \eqn{N(a,1)} while ratings for 
   non-diseased cases are sampled from \eqn{N(0,b^2)}. To avoid clutter error 
   bars are only shown for the lowest and uppermost operating points. An FROC
   dataset is internally converted to a highest rating inferred ROC dataset. To
   many bins containing zero counts will cause the algorithm to fail; so be sure
   to bin the data appropriately to fewer bins, where each bin has at least one
   count.
}
\examples{
\donttest{
## Test with an included ROC dataset
retFit <- FitBinormalRoc(dataset02);print(retFit$fittedPlot)


## Test with an included FROC dataset; it needs to be binned
## as there are more than 5 discrete ratings levels
binned <- DfBinDataset(dataset05, desiredNumBins = 5, opChType = "ROC")
retFit <- FitBinormalRoc(binned);print(retFit$fittedPlot)


## Test with single interior point data
fp <- c(rep(1,7), rep(2, 3))
tp <- c(rep(1,5), rep(2, 5))
dataset <- Df2RJafrocDataset(fp, tp)
retFit <- FitBinormalRoc(dataset);print(retFit$fittedPlot)

## Test with two interior data points
fp <- c(rep(1,7), rep(2, 5), rep(3, 3))
tp <- c(rep(1,3), rep(2, 5), rep(3, 7))
dataset <- Df2RJafrocDataset(fp, tp)
retFit <- FitBinormalRoc(dataset);print(retFit$fittedPlot)

## Test with TONY data for which chisqr can be calculated
ds <- DfFroc2Roc(dataset01)
retFit <- FitBinormalRoc(ds, 2, 3);print(retFit$fittedPlot)
retFit$ChisqrFitStats
 
## Test with included degenerate ROC data
retFit <- FitBinormalRoc(datasetDegenerate);print(retFit$fittedPlot)
}

 

}
\references{
Dorfman DD, Alf E (1969) Maximum-Likelihood Estimation of Parameters of Signal-Detection Theory and Determination of Confidence Intervals - 
Rating-Method Data, Journal of Mathematical Psychology 6, 487-496.

Grey D, Morgan B (1972) Some aspects of ROC curve-fitting: normal and logistic models. Journal of Mathematical Psychology 9, 128-139.
}
