% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilOutputReport.R
\name{UtilOutputReport}
\alias{UtilOutputReport}
\title{Generate a formatted report file}
\usage{
UtilOutputReport (fileName, format = "JAFROC", delimiter = ",", dataset, 
   dataDescription = deparse(substitute(dataset)), reportFile, reportFormat = "txt",
   method = "DBMH", FOM = "wJAFROC", alpha = 0.05, covEstMethod = "Jackknife", 
   nBoots = 200, renumber = FALSE, showWarnings = TRUE)
}
\arguments{
\item{fileName}{A string variable containing the name of the data file 
to be analyzed, see \link{DfReadDataFile} and "Details".}

\item{format}{The format of the data specified in \code{fileName}: 
see \link{DfReadDataFile} and "Details".}

\item{delimiter}{See \link{DfReadDataFile}.}

\item{dataset}{The dataset to be analyzed, \link{RJafroc-package}.}

\item{dataDescription}{Only needed if a dataset is not specified. 
It is a string descriptor of the dataset; the default is the variable 
name of \code{dataset}}

\item{reportFile}{The file name of the output report file. If this parameter 
is missing, the function will use \code{fileName} or \code{dataDescription} 
followed by the underscore separated concatenation of \code{method} 
and \code{FOM} as the output report file.}

\item{reportFormat}{The format of the output report. The two available formats are 
"txt" and "xlsx", which correspond to a formatted text file and an 
Excel file respectively. "txt" is the default.}

\item{method}{The analysis method: \code{"ORH"} or \code{"DBMH"}.}

\item{FOM}{See \link{StSignificanceTesting}.}

\item{alpha}{See \link{StSignificanceTesting}.}

\item{covEstMethod}{See \link{StSignificanceTesting}.}

\item{nBoots}{See \link{StSignificanceTesting}.}

\item{renumber}{A logical variable: if \code{TRUE}, consecutive integers 
(staring from 1) will be used as the modality and reader IDs in the 
output report. Otherwise, modality and reader IDs in the original data 
file will be used. This option may be needed for aesthetics.}

\item{showWarnings}{A \code{logical} variable: if \code{TRUE}, a warning will 
be issued if the report file already exists and the program will wait 
until the user inputs "y" or "n" to determine whether to overwrite the 
existing file. If \code{FALSE}, the existing file will be silently overwritten.}
}
\value{
A formatted report of the data analysis, patterned roughly on that of 
   OR-DBM MRMC V2.5.
}
\description{
Generate a formatted report of the analysis and save to a text file
}
\details{
At least one of the combinations of \code{fileName} and \code{format} 
   or \code{dataset} and \code{dataDescription} must be specified. 
   If both are specified, the data file \code{fileName} is analyzed and 
   the dataset \code{dataset} is ignored.
}
\examples{
\dontrun{
UtilOutputReport(dataset = includedRocData, method = "DBMH", FOM = "Wilcoxon", 
             dataDescription = "MyROCData", showWarnings = FALSE)

## Generate a analysis report for a data file.
fileName <- system.file("extdata", "includedRocData.xlsx", 
package = "RJafroc", mustWork = TRUE)
UtilOutputReport(fileName = fileName, method = "DBMH", FOM = "Wilcoxon",
             showWarnings = FALSE)
             
## Output report for an existing dataset
UtilOutputReport(dataset = includedRocData, method = "DBMH", FOM = "Wilcoxon", 
             reportFile = "MyROCDataAnalysis.txt") 
UtilOutputReport(dataset = includedRocData, method = "ORH", FOM = "Wilcoxon", showWarnings = FALSE)
## UtilOutputReport(dataset = dataset05, 
## method = "DBMH", FOM = "Wilcoxon") # ERROR!
UtilOutputReport(dataset = dataset05, method = "ORH") # default FOM is wJAFROC
UtilOutputReport(dataset = dataset05, method = "DBMH", FOM = "HrAuc")
}
       
}
