% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset10}
\alias{dataset10}
\title{dataset10}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:3, 1:8, 1:90, 1], of false positives, FPs}
\item{\code{LL}}{ Ratings array [1:3, 1:8, 1:40, 1], of true positives, TPs}
\item{\code{lesionNum}}{ array [1:40], number of lesions per diseased case, all set to 1}
\item{\code{lesionID}}{ array [1:40, 1], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:40, 1], weights (or clinical importances) of lesions, all set to 1}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ [1:3] "1" "2" "3", modality labels}
\item{\code{readerID}}{ [1:8] "1" "2" ..., reader labels}
}}
\usage{
dataset10
}
\description{
This is referred to in the book as the "RUS" dataset. It consists of 90 cases, 
40 of which are diseased, the images were
acquired at three dose levels, which can be regarded as modalities.
"0" = conventional film radiographs, "1" = digitized  images viewed on monitors, Eight 
radiologists interpreted the cases using the FROC paradigm. These have been reduced to 
ROC data by using the highest ratings (the original FROC data is lost).
}
\examples{
str(dataset10)
PlotEmpiricalOperatingCharacteristics(dataset = dataset10)$Plot


}
\references{
Ruschin M, et al. Dose dependence of mass and microcalcification 
detection in digital mammography: free response human observer studies. 
Med Phys. 2007;34:400 - 407.
}
\keyword{datasets}
