/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.Observation;
import it.bancaditalia.oss.sdmx.util.Utils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseObservation<T>
implements Serializable,
Comparable<BaseObservation<?>> {
    private static final long serialVersionUID = 1L;
    protected String timeslot;
    protected final Map<String, String> obsAttributes;

    protected BaseObservation(String string, Map<String, String> hashMap) {
        if (string == null || string.isEmpty()) {
            throw new InvalidParameterException("The timeslot for an observation cannot be null or empty.");
        }
        this.timeslot = string;
        this.obsAttributes = hashMap == null ? new HashMap() : hashMap;
    }

    protected BaseObservation(BaseObservation<?> baseObservation) {
        this.timeslot = baseObservation.timeslot;
        this.obsAttributes = baseObservation.obsAttributes;
    }

    public <U> BaseObservation<U> mapValue(Utils.Function<? super T, U> function) {
        return new Observation<U>(this, function.apply(this.getValue()));
    }

    public <U, R> BaseObservation<R> combine(BaseObservation<U> baseObservation, Utils.BiFunction<? super T, ? super U, R> biFunction) {
        return new Observation<R>(this, biFunction.apply(this.getValue(), baseObservation.getValue()));
    }

    public String getTimeslot() {
        return this.timeslot;
    }

    public void setTimeslot(String string) {
        this.timeslot = string;
    }

    public abstract T getValue();

    public double getValueAsDouble() {
        if (this.getValue() instanceof Number) {
            return ((Number)this.getValue()).doubleValue();
        }
        try {
            return Double.parseDouble(this.getValue().toString());
        }
        catch (RuntimeException runtimeException) {
            return Double.NaN;
        }
    }

    public String getValueAsString() {
        return this.getValue().toString();
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.obsAttributes);
    }

    public String getAttributeValue(String string) {
        return this.obsAttributes.get(string);
    }

    @Override
    public int compareTo(BaseObservation<?> baseObservation) {
        return this.timeslot.compareToIgnoreCase(baseObservation.timeslot);
    }
}

