/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.helper.KeyValueTableModel;
import it.bancaditalia.oss.sdmx.helper.ProgressViewer;
import it.bancaditalia.oss.sdmx.helper.QueryPanel;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingWorker;

class GetFlowsTask
extends SwingWorker<Void, Void> {
    private static Logger logger = Configuration.getSdmxLogger();
    private ProgressViewer progress = null;
    private String provider = null;

    public GetFlowsTask(ProgressViewer progressViewer, String string) {
        this.progress = progressViewer;
        this.provider = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        try {
            Map<String, String> map = SdmxClientHandler.getFlows(this.provider, null);
            KeyValueTableModel keyValueTableModel = new KeyValueTableModel("Flow ID", "Flow Description", map);
            JTable jTable = (JTable)QueryPanel.flowsPane.getViewport().getComponent(0);
            jTable.setModel(keyValueTableModel);
            QueryPanel.sorter.setModel(keyValueTableModel);
            QueryPanel.queryLab.setText("Provider: " + QueryPanel.selectedProvider);
        }
        catch (SdmxException sdmxException) {
            logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
            logger.log(Level.FINER, "", sdmxException);
        }
        finally {
            this.progress.setVisible(false);
        }
        return null;
    }
}

