/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.parser.v20.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v20.GenericDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class RestSdmx20Client
extends RestSdmxClient {
    private String acceptHdr = null;
    protected String format = "compact_v2";

    public RestSdmx20Client(String string, URL uRL, boolean bl, String string2, String string3) {
        super(string, uRL, bl, false, false);
        this.acceptHdr = string2;
        this.format = string3;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block12: {
            String string = null;
            InputStreamReader inputStreamReader = null;
            hashMap = new HashMap<String, Dataflow>();
            string = this.buildFlowQuery("ALL", null, null);
            inputStreamReader = this.runQuery(string, null);
            if (inputStreamReader != null) {
                try {
                    List<Dataflow> list = DataflowParser.parse(inputStreamReader);
                    if (list.size() > 0) {
                        hashMap = new HashMap();
                        for (Dataflow dataflow : list) {
                            hashMap.put(dataflow.getId(), dataflow);
                        }
                        break block12;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
            throw new SdmxException("The query returned anull stream");
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        Dataflow dataflow;
        block11: {
            String string4 = null;
            InputStreamReader inputStreamReader = null;
            dataflow = null;
            string4 = this.buildFlowQuery(string, string2, string3);
            inputStreamReader = this.runQuery(string4, null);
            if (inputStreamReader != null) {
                try {
                    List<Dataflow> list = DataflowParser.parse(inputStreamReader);
                    if (list.size() >= 1) {
                        dataflow = list.get(0);
                        break block11;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
            throw new SdmxException("The query returned a null stream");
        }
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        String string = null;
        InputStreamReader inputStreamReader = null;
        DataFlowStructure dataFlowStructure = new DataFlowStructure();
        if (dSDIdentifier != null) {
            string = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion());
            inputStreamReader = this.runQuery(string, null);
            if (inputStreamReader != null) {
                try {
                    dataFlowStructure = DataStructureParser.parse(inputStreamReader).get(0);
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
            throw new SdmxException("The query returned a null stream");
        }
        throw new SdmxException("Null dsd in input");
        return dataFlowStructure;
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        InputStreamReader inputStreamReader = null;
        Map<String, String> map = null;
        string4 = this.buildCodelistQuery(string, string2, string3);
        inputStreamReader = this.runQuery(string4, null);
        if (inputStreamReader != null) {
            try {
                map = CodelistParser.parse(inputStreamReader);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
            finally {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        throw new SdmxException("The query returned a null stream");
        return map;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        String string5 = null;
        InputStreamReader inputStreamReader = null;
        ArrayList<PortableTimeSeries> arrayList = new ArrayList();
        string5 = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
        inputStreamReader = this.runQuery(string5, this.acceptHdr);
        if (inputStreamReader != null) {
            try {
                if (this.format != null) {
                    arrayList = CompactDataParser.parse(inputStreamReader, dataFlowStructure, dataflow.getId(), !bl);
                }
                arrayList = GenericDataParser.parse(inputStreamReader, dataFlowStructure, dataflow.getId(), !bl);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.INFO, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
            finally {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        } else {
            throw new SdmxException("The query returned a null stream");
        }
        return arrayList;
    }

    protected String buildDSDQuery(String string, String string2, String string3) throws SdmxException {
        return super.buildDSDQuery(string, string2, string3, false);
    }

    @Override
    protected String buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            String string5 = RestQueryBuilder.getDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, this.format);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }
}

