/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.helper.CodeSelectionListener;
import it.bancaditalia.oss.sdmx.helper.KeyValueTableModel;
import it.bancaditalia.oss.sdmx.helper.ProgressViewer;
import it.bancaditalia.oss.sdmx.helper.QueryPanel;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingWorker;

class GetCodesTask
extends SwingWorker<Void, Void> {
    private static Logger logger = Configuration.getSdmxLogger();
    private ProgressViewer progress = null;

    public GetCodesTask(ProgressViewer progressViewer) {
        this.progress = progressViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        try {
            Map<String, String> map = SdmxClientHandler.getCodes(QueryPanel.selectedProvider, QueryPanel.selectedDataflow, QueryPanel.selectedDimension);
            JTable jTable = new JTable(new KeyValueTableModel("Code ID", "Code Description", map));
            jTable.setAutoCreateRowSorter(true);
            jTable.getSelectionModel().addListSelectionListener(new CodeSelectionListener());
            QueryPanel.codesPane.getViewport().add(jTable);
            QueryPanel.codeTables.put(QueryPanel.selectedDimension, jTable);
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
        }
        finally {
            this.progress.setVisible(false);
        }
        return null;
    }
}

