/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.util.LoginDialog;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Configuration {
    private static final String sourceClass = Configuration.class.getSimpleName();
    public static final String CONFIGURATION_FILE = "configuration.properties";
    private static final String CENTRAL_CONFIGURATION_FILE_PROP = "SDMX_CONF";
    private static final String PROXY_NAME = "http.proxy.name";
    private static final String PROXY_DEFAULT = "http.proxy.default";
    private static final String HTTP_AUTH_USER = "http.auth.user";
    private static final String PROXY_AUTH_PW = "http.auth.pw";
    public static final String DELAY = "exdi.delay";
    public static final String REVERSE_DUMP = "reverse.dump";
    private static Properties props = new Properties();
    protected static final String LOGGER_NAME = "SDMX";
    protected static final String PROXY_AUTH_KERBEROS = "Kerberos";
    protected static final String PROXY_AUTH_DIGEST = "digest";
    protected static final String PROXY_AUTH_BASIC = "basic";
    protected static final String JAVA_SECURITY_KERBEROS_CONF = "java.security.krb5.conf";
    protected static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    protected static final String HTTP_AUTH_PREF = "http.auth.preference";
    protected static final String SSL_DISABLE_CERT_CHECK = "ssl.disable.cert.check";
    protected static final String SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    protected static Logger SDMX_LOGGER = null;

    protected static void setSdmxLogger() {
        if (SDMX_LOGGER == null) {
            SDMX_LOGGER = Logger.getLogger(LOGGER_NAME);
            LogManager.getLogManager().addLogger(SDMX_LOGGER);
        }
    }

    public static Logger getSdmxLogger() {
        Configuration.setSdmxLogger();
        return SDMX_LOGGER;
    }

    public static boolean isSSLCertificatesDisabled() {
        return props.getProperty(SSL_DISABLE_CERT_CHECK, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean isReverse() {
        return props.getProperty(REVERSE_DUMP, "TRUE").equalsIgnoreCase("TRUE");
    }

    public static long getDelay() {
        String string = props.getProperty(DELAY, null);
        if (string == null) {
            return 0L;
        }
        return Integer.parseInt(string);
    }

    public static void init() {
        String string;
        Configuration.setSdmxLogger();
        System.setProperty("http.agent", LOGGER_NAME);
        String string2 = null;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        if (new File(CONFIGURATION_FILE).exists()) {
            try {
                fileInputStream = new FileInputStream(CONFIGURATION_FILE);
                fileInputStream2 = new FileInputStream(CONFIGURATION_FILE);
                Configuration.init(fileInputStream, fileInputStream2);
                string2 = "local";
                SDMX_LOGGER.info("Using " + string2 + " configuration.");
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((string = System.getenv(CENTRAL_CONFIGURATION_FILE_PROP)) != null && !string.isEmpty() && new File(string).exists()) {
            try {
                fileInputStream = new FileInputStream(string);
                fileInputStream2 = new FileInputStream(string);
                Configuration.init(fileInputStream, fileInputStream2);
                string2 = "global";
                SDMX_LOGGER.info("Using " + string2 + " configuration.");
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Class<?> clazz = Class.forName("sdmx.SdmxConfiguration");
            Method method = clazz.getMethod("initBI", new Class[0]);
            method.invoke((Object)null, new Object[0]);
            string2 = "sdmxclass";
        }
        catch (Exception exception) {
            string2 = "default";
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.INFO);
            SDMX_LOGGER.addHandler(consoleHandler);
        }
        SDMX_LOGGER.info("Using " + string2 + " configuration.");
    }

    public static void init(InputStream inputStream, InputStream inputStream2) throws SecurityException, IOException {
        Configuration.setSdmxLogger();
        LogManager.getLogManager().readConfiguration(inputStream);
        inputStream.close();
        props.load(inputStream2);
        inputStream2.close();
        String string = props.getProperty(SSL_TRUSTSTORE);
        if (string != null && !string.isEmpty()) {
            System.setProperty(SSL_TRUSTSTORE, string);
        }
        Configuration.configureProxy(props);
    }

    private static void configureProxy(Properties properties) {
        String string;
        Object object;
        String string2;
        String[] stringArray;
        Logger logger = SDMX_LOGGER;
        logger.entering(sourceClass, "configureProxy");
        String string3 = properties.getProperty(PROXY_DEFAULT);
        String string4 = null;
        int n = 0;
        if (string3 != null && !string3.isEmpty()) {
            stringArray = string3.split(":");
            if (stringArray.length != 2 || stringArray[0] == null || stringArray[0].isEmpty() || stringArray[1] == null || stringArray[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. found: '" + string3 + "'");
            }
            string4 = stringArray[0].trim();
            n = Integer.parseInt(stringArray[1].trim());
        }
        stringArray = new SdmxProxySelector(string4, n);
        int n2 = 0;
        while ((string2 = properties.getProperty(PROXY_NAME + n2)) != null && !string2.isEmpty()) {
            object = null;
            object = string2.split(":");
            if (object == null || ((String[])object).length != 2 || object[0] == null || object[0].isEmpty() || object[1] == null || object[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + object[0] + "', port: '" + object[1] + "'");
            }
            string = properties.getProperty(PROXY_NAME + n2 + ".urls");
            if (string != null && !string.isEmpty()) {
                String[] stringArray2 = string.split(",");
                stringArray.addProxy((String)object[0], (String)object[1], stringArray2);
                logger.finer("Proxy has been configured: '" + string2 + "' for " + string);
            }
            ++n2;
        }
        ProxySelector.setDefault((ProxySelector)stringArray);
        if (properties != null) {
            String string5 = properties.getProperty(HTTP_AUTH_PREF);
            if (string5 != null) {
                string5 = string5.trim();
                System.setProperty(HTTP_AUTH_PREF, string5);
                logger.finer(string5 + " authentication enabled.");
                if (string5.equalsIgnoreCase(PROXY_AUTH_KERBEROS)) {
                    string2 = properties.getProperty(JAVA_SECURITY_KERBEROS_CONF);
                    object = properties.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
                    string = System.getenv().get("KRB5CCNAME");
                    if (string != null && object != null && string2 != null) {
                        string = string.trim();
                        object = ((String)object).trim();
                        string2 = string2.trim();
                        System.setProperty("user.krb5cc", string);
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        System.setProperty(JAVA_SECURITY_KERBEROS_CONF, string2);
                        System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, (String)object);
                        logger.finer("java.security.krb5.conf = " + string2);
                        logger.finer("java.security.auth.login.config = " + (String)object);
                        logger.finer("Environment variable KRB5CCNAME = " + string);
                    } else {
                        logger.warning("Kerberos ticket cache not configured because one of the parameters is not set.");
                        logger.warning("java.security.krb5.conf = " + string2);
                        logger.warning("java.security.auth.login.config = " + (String)object);
                        logger.warning("Environment variable KRB5CCNAME = " + string);
                    }
                } else if (string5.equalsIgnoreCase(PROXY_AUTH_BASIC)) {
                    string2 = properties.getProperty(HTTP_AUTH_USER);
                    object = properties.getProperty(PROXY_AUTH_PW);
                    Configuration.setCredentials(string5, string2, (String)object);
                } else {
                    logger.finer("Authentication type not supported: " + string5);
                }
            } else {
                logger.finer("No authentication enabled.");
            }
        }
        logger.exiting(sourceClass, "configureProxy");
    }

    private static void setCredentials(String string, String string2, String string3) {
        Object object;
        Object object2;
        System.setProperty(HTTP_AUTH_PREF, string);
        if (string2 == null || string3 == null) {
            object2 = new JFrame("Proxy Authentication");
            ((JFrame)object2).setDefaultCloseOperation(2);
            object = new LoginDialog((Frame)object2, "Proxy Authentication");
            ((Dialog)object).setVisible(true);
            string2 = ((LoginDialog)object).getUsername();
            string3 = ((LoginDialog)object).getPassword();
            ((Window)object2).dispose();
        }
        object2 = string2.trim();
        object = string3.trim();
        Authenticator.setDefault(new Authenticator((String)object2, (String)object){
            final /* synthetic */ String val$user;
            final /* synthetic */ String val$pw;
            {
                this.val$user = string;
                this.val$pw = string2;
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Logger logger = SDMX_LOGGER;
                logger.entering(sourceClass, "getPasswordAuthentication");
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.val$user, this.val$pw.toCharArray());
                logger.finer("Requesting Host  : " + this.getRequestingHost());
                logger.finer("Requesting Port  : " + this.getRequestingPort());
                logger.finer("Requesting Protocol: " + this.getRequestingProtocol());
                logger.finer("Requesting Scheme : " + this.getRequestingScheme());
                logger.entering(sourceClass, "getPasswordAuthentication");
                return passwordAuthentication;
            }
        });
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }
}

