/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.calendars.DayEvent;
import ec.tstoolkit.timeseries.calendars.EasterRelatedDay;
import ec.tstoolkit.timeseries.calendars.FixedDay;
import ec.tstoolkit.timeseries.calendars.IDayInfo;
import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class SpecialCalendarDay
implements ISpecialDay {
    public final DayEvent event;
    public final int offset;
    private final double weight;
    private final boolean julian;

    public SpecialCalendarDay(DayEvent ev, int off) {
        this(ev, off, 1.0);
    }

    public SpecialCalendarDay(DayEvent ev, int off, double weight) {
        this(ev, off, weight, false);
    }

    public SpecialCalendarDay(DayEvent ev, int off, boolean julianeaster) {
        this(ev, off, 1.0, julianeaster);
    }

    public SpecialCalendarDay(DayEvent ev, int off, double weight, boolean julianeaster) {
        this.event = ev;
        this.offset = off;
        this.weight = weight;
        this.julian = julianeaster;
    }

    public ISpecialDay toSpecialDay() {
        switch (this.event) {
            case ShroveMonday: {
                return this.julian ? EasterRelatedDay.JulianShroveMonday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.ShroveMonday.reweight(this.weight).plus(this.offset);
            }
            case ShroveTuesday: {
                return this.julian ? EasterRelatedDay.JulianShroveTuesday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.ShroveTuesday.reweight(this.weight).plus(this.offset);
            }
            case AshWednesday: {
                return this.julian ? EasterRelatedDay.JulianAshWednesday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.AshWednesday.reweight(this.weight).plus(this.offset);
            }
            case Easter: {
                return this.julian ? EasterRelatedDay.JulianEaster.reweight(this.weight).plus(this.offset) : EasterRelatedDay.Easter.reweight(this.weight).plus(this.offset);
            }
            case MaundyThursday: {
                return this.julian ? EasterRelatedDay.JulianEasterThursday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EasterThursday.reweight(this.weight).plus(this.offset);
            }
            case GoodFriday: {
                return this.julian ? EasterRelatedDay.JulianEasterFriday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EasterFriday.reweight(this.weight).plus(this.offset);
            }
            case EasterMonday: {
                return this.julian ? EasterRelatedDay.JulianEasterMonday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EasterMonday.reweight(this.weight).plus(this.offset);
            }
            case Ascension: {
                return this.julian ? EasterRelatedDay.JulianAscension.reweight(this.weight).plus(this.offset) : EasterRelatedDay.Ascension.reweight(this.weight).plus(this.offset);
            }
            case Pentecost: {
                return this.julian ? EasterRelatedDay.JulianPentecost.reweight(this.weight).plus(this.offset) : EasterRelatedDay.Pentecost.reweight(this.weight).plus(this.offset);
            }
            case WhitMonday: {
                return this.julian ? EasterRelatedDay.JulianPentecostMonday.reweight(this.weight).plus(this.offset) : EasterRelatedDay.PentecostMonday.reweight(this.weight).plus(this.offset);
            }
            case CorpusChristi: {
                return this.julian ? EasterRelatedDay.JulianCorpusChristi.reweight(this.weight).plus(this.offset) : EasterRelatedDay.CorpusChristi.reweight(this.weight).plus(this.offset);
            }
            case Assumption: {
                return FixedDay.Assumption.reweight(this.weight).plus(this.offset);
            }
            case Christmas: {
                return FixedDay.Christmas.reweight(this.weight).plus(this.offset);
            }
            case NewYear: {
                return FixedDay.NewYear.reweight(this.weight).plus(this.offset);
            }
            case MayDay: {
                return FixedDay.MayDay.reweight(this.weight).plus(this.offset);
            }
            case AllSaintsDay: {
                return FixedDay.AllSaintsDay.reweight(this.weight).plus(this.offset);
            }
            case Halloween: {
                return FixedDay.Halloween.reweight(this.weight).plus(this.offset);
            }
        }
        return null;
    }

    public boolean isJulianEaster() {
        return this.julian;
    }

    @Override
    public Iterable<IDayInfo> getIterable(TsFrequency freq, Day start, Day end) {
        ISpecialDay sd = this.toSpecialDay();
        if (sd == null) {
            return null;
        }
        return sd.getIterable(freq, start, end);
    }

    @Override
    public double[][] getLongTermMeanEffect(int freq) {
        ISpecialDay sd = this.toSpecialDay();
        if (sd == null) {
            return null;
        }
        return sd.getLongTermMeanEffect(freq);
    }

    @Override
    public TsDomain getSignificantDomain(TsFrequency freq, Day start, Day end) {
        ISpecialDay sd = this.toSpecialDay();
        if (sd == null) {
            return null;
        }
        return sd.getSignificantDomain(freq, start, end);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean match(ISpecialDay.Context context) {
        return context.isJulianEaster() == this.julian;
    }
}

