/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.LinearFilterException;
import ec.tstoolkit.maths.linearfilters.Utilities;

public abstract class AbstractFiniteFilter
implements IFiniteFilter {
    protected void defaultFilter(DataBlock in, DataBlock out, int lb, int ub) {
        int nw = ub - lb + 1;
        DataBlock cur = in.drop(0, nw - 1);
        out.product(cur, this.getWeight(lb));
        for (int j = 1; j < nw; ++j) {
            cur.move(1);
            out.addAY(this.getWeight(lb + j), cur);
        }
    }

    protected void exFilter(DataBlock in, DataBlock out, int lb, int ub) {
        if (lb > 0 || ub < 0) {
            throw new LinearFilterException("lf_err_sfilter");
        }
        this.defaultFilter(in, out.drop(-lb, ub), lb, ub);
    }

    public void extendedFilter(DataBlock in, DataBlock out) {
        int lb = this.getLowerBound();
        int ub = this.getUpperBound();
        int nw = ub - lb + 1;
        out.product(in, this.getWeight(ub--));
        for (int j = 1; j < nw; ++j) {
            out.drop(j, 0).addAY(this.getWeight(ub--), in.drop(0, j));
        }
    }

    @Override
    public boolean filter(DataBlock in, DataBlock out) {
        int nout;
        int lb = this.getLowerBound();
        int ub = this.getUpperBound();
        int nw = ub - lb + 1;
        int nin = in.getLength();
        if (nin == (nout = out.getLength())) {
            this.extendedFilter(in, out);
            return true;
        }
        if (nin < nw || out.getLength() != nin - nw + 1) {
            return false;
        }
        this.defaultFilter(in, out, lb, ub);
        return true;
    }

    @Override
    public Complex frequencyResponse(double freq) {
        double[] w = this.getWeights();
        return Utilities.frequencyResponse(w, this.getLowerBound(), freq);
    }

    @Override
    public int getLength() {
        return this.getUpperBound() - this.getLowerBound() + 1;
    }

    @Override
    public abstract int getLowerBound();

    @Override
    public abstract int getUpperBound();

    @Override
    public abstract double getWeight(int var1);

    @Override
    public double[] getWeights() {
        int lb = this.getLowerBound();
        int ub = this.getUpperBound();
        double[] w = new double[ub - lb + 1];
        for (int i = 0; i < w.length; ++i) {
            w[i] = this.getWeight(lb + i);
        }
        return w;
    }

    @Override
    public boolean hasLowerBound() {
        return true;
    }

    @Override
    public boolean hasUpperBound() {
        return true;
    }

    @Override
    public int inPlaceFilter(DataBlock data) {
        int start = this.getLength() - 1;
        int n = data.getLength() - start;
        if (n <= 0) {
            return -1;
        }
        double[] x = new double[n];
        DataBlock r = new DataBlock(x);
        this.filter(data, r);
        data.drop(start, 0).copyFrom(x, 0);
        return start;
    }

    public void solve(double[] in, double[] out) {
        int j;
        double z;
        int i;
        int n = in.length;
        double[] w = this.getWeights();
        int u = w.length - 1;
        int nmax = Math.min(w.length, n);
        double a = w[u];
        for (i = 0; i < nmax; ++i) {
            z = in[i];
            for (j = 1; j <= i; ++j) {
                z -= out[i - j] * w[u - j];
            }
            out[i] = z / a;
        }
        for (i = w.length; i < n; ++i) {
            z = in[i];
            for (j = 1; j <= u; ++j) {
                z -= out[i - j] * w[u - j];
            }
            out[i] = z / a;
        }
    }

    public void solve(DataBlock in, DataBlock out) {
        int j;
        double z;
        int i;
        int n = in.getLength();
        double[] w = this.getWeights();
        int u = w.length - 1;
        int nmax = Math.min(w.length, n);
        double a = w[u];
        for (i = 0; i < nmax; ++i) {
            z = in.get(i);
            for (j = 1; j <= i; ++j) {
                z -= out.get(i - j) * w[u - j];
            }
            out.set(i, z / a);
        }
        for (i = w.length; i < n; ++i) {
            z = in.get(i);
            for (j = 1; j <= u; ++j) {
                z -= out.get(i - j) * w[u - j];
            }
            out.set(i, z / a);
        }
    }
}

