/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.ws;

import demetra.datatypes.sa.SaProcessingType;
import demetra.workspace.WorkspaceFamily;
import demetra.workspace.WorkspaceItem;
import demetra.workspace.file.FileFormat;
import demetra.workspace.file.FileRepository;
import demetra.workspace.file.FileWorkspace;
import demetra.workspace.util.Paths;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.jdr.ws.MultiProcessing;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.regression.TsVariables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jdr.spec.ts.Utility;

public class Workspace {
    private final ProcessingContext context;
    private final List<MultiProcessing> multiProcessing = new ArrayList<MultiProcessing>();

    public static Workspace open(String fileName) throws IOException {
        File file = new File(fileName);
        FileWorkspace fws = FileWorkspace.open(file.toPath());
        Collection<WorkspaceItem> items = fws.getItems();
        ProcessingContext context = new ProcessingContext();
        Map<WorkspaceItem, GregorianCalendarManager> cal = FileRepository.loadAllCalendars(fws, context);
        Map<WorkspaceItem, TsVariables> vars = FileRepository.loadAllVariables(fws, context);
        Map<WorkspaceItem, SaProcessingType> sa = FileRepository.loadAllSaProcessing(fws, context);
        Workspace ws = new Workspace(context);
        for (Map.Entry<WorkspaceItem, SaProcessingType> entry : sa.entrySet()) {
            ws.multiProcessing.add(MultiProcessing.of(entry.getKey().getLabel(), entry.getValue()));
        }
        return ws;
    }

    public static Workspace create(Utility.Dictionary dic) {
        return new Workspace(dic == null ? new ProcessingContext() : dic.toContext());
    }

    public MultiProcessing getMultiProcessing(int idx) {
        return this.multiProcessing.get(idx);
    }

    public int getMultiProcessingCount() {
        return this.multiProcessing.size();
    }

    public MultiProcessing newMultiProcessing(String name) {
        MultiProcessing n = MultiProcessing.of(name, new SaProcessingType());
        this.multiProcessing.add(n);
        return n;
    }

    private Workspace(ProcessingContext context) {
        this.context = context;
    }

    public ProcessingContext getContext() {
        return this.context;
    }

    public Utility.Dictionary dictionary() {
        return Utility.Dictionary.fromContext(this.context);
    }

    public void computeAll() {
        this.multiProcessing.parallelStream().forEach(p -> p.compute(this.context));
    }

    public void compute(String name) {
        for (MultiProcessing p : this.multiProcessing) {
            if (!p.getName().equals(name)) continue;
            p.compute(this.context);
        }
    }

    public boolean save(String fileName) {
        File file = new File(fileName);
        try {
            try (FileWorkspace fws = FileWorkspace.create(file.toPath(), FileFormat.GENERIC);){
                WorkspaceItem cur;
                fws.setName(Paths.getBaseName(fileName));
                for (MultiProcessing p : this.multiProcessing) {
                    cur = WorkspaceItem.builder().family(WorkspaceFamily.SA_MULTI).id(p.getName()).label(p.getName()).build();
                    SaProcessingType sa = p.toType();
                    fws.store(cur, sa);
                }
                String[] names = this.context.getTsVariableManagers().getNames();
                for (int i = 0; i < names.length; ++i) {
                    cur = WorkspaceItem.builder().family(WorkspaceFamily.UTIL_VAR).id(names[i]).label(names[i]).build();
                    fws.store(cur, this.context.getTsVariables(names[i]));
                }
                WorkspaceItem cal = WorkspaceItem.builder().family(WorkspaceFamily.UTIL_CAL).id("Calendars").label("Calendars").build();
                fws.store(cal, this.context.getGregorianCalendars());
            }
            return true;
        }
        catch (IOException err) {
            return false;
        }
    }
}

