/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.sa.tramoseats;

import demetra.xml.IXmlConverter;
import demetra.xml.sa.AbstractXmlSaSpecification;
import demetra.xml.sa.XmlRegressionSpec;
import demetra.xml.sa.tramoseats.AbstractXmlArimaSpec;
import demetra.xml.sa.tramoseats.XmlArimaSpec;
import demetra.xml.sa.tramoseats.XmlAutoModelSpec;
import demetra.xml.sa.tramoseats.XmlCalendarSpec;
import demetra.xml.sa.tramoseats.XmlEstimateSpec;
import demetra.xml.sa.tramoseats.XmlOutlierSpec;
import demetra.xml.sa.tramoseats.XmlSeatsSpec;
import demetra.xml.sa.tramoseats.XmlTransformSpec;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="tramoseatsSpec")
@XmlType(name="tramoseatsSpecType")
public class XmlTramoSeatsSpecification
extends AbstractXmlSaSpecification
implements IXmlConverter<TramoSeatsSpecification> {
    static final String NAME = "tramoseatsSpecType";
    static final String RNAME = "tramoseatsSpec";
    @XmlElement
    public XmlTransformSpec transformSpec;
    @XmlElement
    public XmlOutlierSpec outlierSpec;
    @XmlElements(value={@XmlElement(name="autoModelSpec", type=XmlAutoModelSpec.class), @XmlElement(name="arimaSpec", type=XmlArimaSpec.class)})
    public AbstractXmlArimaSpec modelSpec;
    @XmlElement
    public XmlCalendarSpec calendarSpec;
    @XmlElement
    public XmlRegressionSpec regressionSpec;
    @XmlElement
    public XmlEstimateSpec estimateSpec;
    @XmlElement
    public XmlSeatsSpec decompositionSpec;

    public void copyTo(TramoSeatsSpecification spec) {
        if (this.transformSpec != null) {
            this.transformSpec.copyTo(spec);
        }
        if (this.outlierSpec != null) {
            this.outlierSpec.copyTo(spec);
        }
        if (this.modelSpec != null) {
            this.modelSpec.copyTo(spec);
        }
        if (this.regressionSpec != null) {
            RegressionSpec regs = spec.getTramoSpecification().getRegression();
            regs.setOutliers(this.regressionSpec.createOutliers());
            regs.setInterventionVariables(this.regressionSpec.createInterventions());
            regs.setRamps(this.regressionSpec.createRamps());
            regs.setUserDefinedVariables(this.regressionSpec.createVariables());
        }
        if (this.calendarSpec != null) {
            this.calendarSpec.copyTo(spec);
        }
        if (this.estimateSpec != null) {
            spec.getTramoSpecification().setEstimate(this.estimateSpec.create());
        }
        if (this.decompositionSpec != null) {
            spec.setSeatsSpecification(this.decompositionSpec.create());
        }
    }

    public TramoSeatsSpecification convert(boolean useSystem) {
        TramoSeatsSpecification spec = this.create();
        if (!useSystem) {
            return spec;
        }
        TramoSeatsSpecification s = spec.matchSystem();
        if (s != null) {
            return s;
        }
        return spec;
    }

    @Override
    public TramoSeatsSpecification create() {
        TramoSeatsSpecification spec = new TramoSeatsSpecification();
        this.copyTo(spec);
        return spec;
    }

    @Override
    public void copy(TramoSeatsSpecification t) {
        this.transformSpec = XmlTransformSpec.create(t.getTramoSpecification().getTransform());
        this.modelSpec = AbstractXmlArimaSpec.create(t.getTramoSpecification());
        this.outlierSpec = XmlOutlierSpec.create(t.getTramoSpecification().getOutliers());
        this.calendarSpec = XmlCalendarSpec.create(t.getTramoSpecification().getRegression());
        this.regressionSpec = new XmlRegressionSpec();
        this.regressionSpec.add(t.getTramoSpecification().getRegression().getOutliers());
        this.regressionSpec.add(t.getTramoSpecification().getRegression().getRamps());
        this.regressionSpec.add(t.getTramoSpecification().getRegression().getUserDefinedVariables());
        this.regressionSpec.add(t.getTramoSpecification().getRegression().getInterventionVariables());
        if (this.regressionSpec.isEmpty()) {
            this.regressionSpec = null;
        }
        if (!t.getTramoSpecification().getEstimate().isDefault()) {
            this.estimateSpec = new XmlEstimateSpec();
            this.estimateSpec.copy(t.getTramoSpecification().getEstimate());
        }
        this.decompositionSpec = new XmlSeatsSpec();
        this.decompositionSpec.copy(t.getSeatsSpecification());
    }
}

