/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices.lapack;

import ec.tstoolkit.maths.Constants;
import ec.tstoolkit.maths.matrices.lapack.Dlapy2;
import ec.tstoolkit.maths.matrices.lapack.Dnrm2;
import ec.tstoolkit.maths.matrices.lapack.Dscal;

@Deprecated
public class Dlarfg {
    private static final double ZERO = 0.0;
    private static final double ONE = 1.0;
    private double m_beta;
    private double m_tau;
    private double m_alpha;

    public final double beta() {
        return this.m_beta;
    }

    public final double scale() {
        return this.m_alpha;
    }

    public final void fn(int n, double alpha, double[] x, int ix, int incx) {
        this.m_beta = this.m_alpha = alpha;
        this.m_tau = 0.0;
        if (n <= 1) {
            return;
        }
        double xnorm = Dnrm2.fn(n - 1, x, ix, incx);
        if (xnorm == 0.0) {
            return;
        }
        this.m_beta = -Dlapy2.fn(this.m_alpha, xnorm) * Math.signum(this.m_alpha);
        double safmin = Constants.getSafeMinimum() / Constants.getEpsilon();
        if (Math.abs(this.m_beta) < safmin) {
            double rsafmin = 1.0 / safmin;
            int knt = 0;
            do {
                ++knt;
                Dscal.fn(n - 1, rsafmin, x, ix, incx);
                this.m_beta *= rsafmin;
                this.m_alpha *= rsafmin;
            } while (Math.abs(this.m_beta) < safmin);
            xnorm = Dnrm2.fn(n - 1, x, ix, incx);
            this.m_beta = -Dlapy2.fn(this.m_alpha, xnorm) * Math.signum(this.m_alpha);
            this.m_tau = (this.m_beta - this.m_alpha) / this.m_beta;
            Dscal.fn(n - 1, 1.0 / (this.m_alpha - this.m_beta), x, ix, incx);
            for (int j = 0; j < knt; ++j) {
                this.m_beta *= safmin;
            }
        } else {
            this.m_tau = (this.m_beta - this.m_alpha) / this.m_beta;
            Dscal.fn(n - 1, 1.0 / (this.m_alpha - this.m_beta), x, ix, incx);
        }
    }

    public final double tau() {
        return this.m_tau;
    }
}

