/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;
import ec.tstoolkit.sarima.estimation.IarimaInitializer;

public class DefaultSarimaInitializer
implements IarimaInitializer {
    private final double ar_;
    private final double ma_;

    public DefaultSarimaInitializer() {
        this.ar_ = -0.1;
        this.ma_ = -0.2;
    }

    public DefaultSarimaInitializer(double ar, double ma) {
        this.ar_ = ar;
        this.ma_ = ma;
    }

    @Override
    public SarimaModel initialize(RegArimaModel<SarimaModel> regs) {
        return this.doDefaultModel(regs.getArima().getSpecification());
    }

    public SarimaModel doDefaultModel(SarimaSpecification spec) {
        int j;
        SarimaModel m = new SarimaModel(spec);
        for (j = 1; j <= spec.getP(); ++j) {
            m.setPhi(j, this.ar_);
        }
        for (j = 1; j <= spec.getBP(); ++j) {
            m.setBPhi(j, this.ar_);
        }
        for (j = 1; j <= spec.getQ(); ++j) {
            m.setTheta(j, this.ma_);
        }
        for (j = 1; j <= spec.getBQ(); ++j) {
            m.setBTheta(j, this.ma_);
        }
        return m;
    }

    public SarimaModel doDefaultModel(SarmaSpecification spec) {
        int j;
        SarimaModel m = new SarimaModel(spec);
        for (j = 1; j <= spec.getP(); ++j) {
            m.setPhi(j, this.ar_);
        }
        for (j = 1; j <= spec.getBP(); ++j) {
            m.setBPhi(j, this.ar_);
        }
        for (j = 1; j <= spec.getQ(); ++j) {
            m.setTheta(j, this.ma_);
        }
        for (j = 1; j <= spec.getBQ(); ++j) {
            m.setBTheta(j, this.ma_);
        }
        return m;
    }
}

