/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.estimation.ConcentratedLikelihoodEstimation;
import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.dstats.T;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.ParameterInfo;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.stats.RunsTestKind;
import ec.tstoolkit.stats.TestofRuns;
import ec.tstoolkit.stats.TestofUpDownRuns;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ModelEstimation
implements IProcResults {
    private double logtransform_;
    private RegArimaModel<SarimaModel> model_;
    private ConcentratedLikelihood likelihood_;
    private LikelihoodStatistics statistics_;
    private NiidTests tests_;
    private Matrix pcov_;
    public static final String LIKELIHOOD = "likelihood";
    public static final String NP = "np";
    public static final String NEFFOBS = "neffectiveobs";
    public static final String ADJLVAL = "adjustedlogvalue";
    public static final String LVAL = "logvalue";
    public static final String SSQERR = "ssqerr";
    public static final String SER = "ser";
    public static final String SERML = "ser-ml";
    public static final String AIC = "aic";
    public static final String AICC = "aicc";
    public static final String BIC = "bic";
    public static final String BICC = "bicc";
    public static final String RESIDUALS = "residuals";
    public static final String RES_DATA = "res";
    public static final String RES_STDERR = "stderr";
    public static final String RES_MEAN = "mean";
    public static final String RES_SKEWNESS = "skewness";
    public static final String RES_KURTOSIS = "kurtosis";
    public static final String RES_DH = "dh";
    public static final String RES_LB = "lb";
    public static final String RES_LB2 = "lb2";
    public static final String RES_SEASLB = "seaslb";
    public static final String RES_BP = "bp";
    public static final String RES_BP2 = "bp2";
    public static final String RES_SEASBP = "seasbp";
    public static final String RES_UD_NUMBER = "nudruns";
    public static final String RES_UD_LENGTH = "ludruns";
    public static final String RES_RUNS_NUMBER = "nruns";
    public static final String RES_RUNS_LENGTH = "lruns";
    public static final String ARIMA = "arima";
    public static final String ARIMA_COVAR = "covar";
    public static final String ARIMA_MEAN = "mean";
    public static final String ARIMA_P = "p";
    public static final String ARIMA_D = "d";
    public static final String ARIMA_Q = "q";
    public static final String ARIMA_BP = "bp";
    public static final String ARIMA_BD = "bd";
    public static final String ARIMA_BQ = "bq";
    public static final String ARIMA_PHI = "phi";
    public static final String ARIMA_PHI1 = "phi(1)";
    public static final String ARIMA_PHI2 = "phi(2)";
    public static final String ARIMA_PHI3 = "phi(3)";
    public static final String ARIMA_PHI4 = "phi(4)";
    public static final String ARIMA_TH = "th";
    public static final String ARIMA_TH1 = "th(1)";
    public static final String ARIMA_TH2 = "th(2)";
    public static final String ARIMA_TH3 = "th(3)";
    public static final String ARIMA_TH4 = "th(4)";
    public static final String ARIMA_BPHI = "bphi";
    public static final String ARIMA_BPHI1 = "bphi(1)";
    public static final String ARIMA_BTH = "bth";
    public static final String ARIMA_BTH1 = "bth(1)";
    private static final InformationMapping<ModelEstimation> MAPPING = new InformationMapping<ModelEstimation>(ModelEstimation.class);

    public ModelEstimation(RegArimaModel<SarimaModel> model) {
        this.model_ = model;
    }

    public ModelEstimation(RegArimaModel<SarimaModel> model, double transformCorrection) {
        this.model_ = model;
        this.logtransform_ = transformCorrection;
    }

    public DataBlock getLinearizedData() {
        int i;
        DataBlock res = this.model_.getY().deepClone();
        double[] b = this.likelihood_.getB();
        if (b == null) {
            return res;
        }
        int start = this.model_.isMeanCorrection() ? 1 : 0;
        int[] missings = this.model_.getMissings();
        if (missings != null) {
            for (i = 0; i < missings.length; ++i) {
                res.add(missings[i], -b[start + i]);
            }
            start += missings.length;
        }
        if (b != null) {
            for (i = start; i < b.length; ++i) {
                res.addAY(-b[i], this.model_.X(i - start));
            }
        }
        return res;
    }

    public DataBlock getCorrectedData(int start, int end) {
        DataBlock res = this.model_.getY().deepClone();
        if (start == end) {
            return res;
        }
        double[] b = this.likelihood_.getB();
        if (b != null) {
            int del = this.model_.isMeanCorrection() ? 1 : 0;
            for (int i = start; i < end; ++i) {
                res.addAY(-b[i + del], this.model_.X(i));
            }
        }
        return res;
    }

    public DataBlock getOlsResiduals() {
        Ols ols;
        RegModel dmodel = this.model_.getDModel();
        DataBlock yc = dmodel.getY();
        if (dmodel.getVarsCount() > 0 && (ols = new Ols()).process(dmodel)) {
            yc = dmodel.calcRes(new ReadDataBlock(ols.getLikelihood().getB()));
        }
        return yc;
    }

    public DataBlock getFullResiduals() {
        RegArimaEstimation<SarimaModel> tmp = new RegArimaEstimation<SarimaModel>(this.model_, this.likelihood_);
        return new DataBlock(tmp.fullResiduals());
    }

    public boolean computeLikelihood(int nhp) {
        ConcentratedLikelihoodEstimation estimation = new ConcentratedLikelihoodEstimation();
        if (estimation.estimate(this.model_)) {
            this.likelihood_ = estimation.getLikelihood();
            this.statistics_ = new RegArimaEstimation<SarimaModel>(this.model_, this.likelihood_).statistics(nhp, this.logtransform_);
            this.tests_ = null;
            return true;
        }
        return false;
    }

    public boolean compute(IRegArimaProcessor<SarimaModel> monitor, int nhp) {
        if (this.likelihood_ != null) {
            return true;
        }
        RegArimaEstimation<SarimaModel> estimation = monitor.process(this.model_);
        if (estimation != null) {
            this.model_ = estimation.model;
            this.likelihood_ = estimation.likelihood;
            this.statistics_ = estimation.statistics(nhp, this.logtransform_);
            this.tests_ = null;
            return true;
        }
        return false;
    }

    public boolean improve(IRegArimaProcessor<SarimaModel> monitor, int nhp) {
        RegArimaEstimation<SarimaModel> estimation = monitor.optimize(this.model_);
        if (estimation != null) {
            this.model_ = estimation.model;
            this.likelihood_ = estimation.likelihood;
            this.statistics_ = estimation.statistics(nhp, this.logtransform_);
            this.tests_ = null;
            return true;
        }
        return false;
    }

    public void updateParametersCovariance(Matrix pvar) {
        this.pcov_ = pvar;
    }

    public ConcentratedLikelihood getLikelihood() {
        return this.likelihood_;
    }

    public LikelihoodStatistics getStatistics() {
        return this.statistics_;
    }

    public NiidTests getNiidTests() {
        if (this.tests_ == null && this.likelihood_ != null) {
            this.tests_ = new NiidTests(this.getFullResiduals(), this.model_.getArima().getFrequency(), this.calcFreeParameters(), true);
        }
        return this.tests_;
    }

    private int calcFreeParameters() {
        if (this.pcov_ == null) {
            return 0;
        }
        DataBlock diag = this.pcov_.diagonal();
        int n = 0;
        for (int i = 0; i < diag.getLength(); ++i) {
            if (!(diag.get(i) > 0.0)) continue;
            ++n;
        }
        return n;
    }

    public RegArimaModel<SarimaModel> getRegArima() {
        return this.model_;
    }

    public SarimaModel getArima() {
        return this.model_.getArima();
    }

    public Matrix getParametersCovariance() {
        return this.pcov_;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        ModelEstimation.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public static InformationMapping<ModelEstimation> getMapping() {
        return MAPPING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setMapping(String name, Class<T> tclass, Function<ModelEstimation, T> extractor) {
        InformationMapping<ModelEstimation> informationMapping = MAPPING;
        synchronized (informationMapping) {
            MAPPING.set(name, tclass, extractor);
        }
    }

    private static ParameterInfo param(ModelEstimation source, String name, int lag) {
        SarimaModel arima = source.getArima();
        int pos = -1;
        switch (name) {
            case "phi": {
                pos = arima.getPhiPosition(lag);
                break;
            }
            case "bphi": {
                pos = arima.getBPhiPosition(lag);
                break;
            }
            case "th": {
                pos = arima.getThetaPosition(lag);
                break;
            }
            case "bth": {
                pos = arima.getBThetaPosition(lag);
                break;
            }
        }
        if (pos < 0) {
            return null;
        }
        double err = source.pcov_ == null ? 0.0 : Math.sqrt(source.pcov_.get(pos, pos));
        Parameter p = new Parameter(arima.getParameter(pos), err == 0.0 ? ParameterType.Fixed : ParameterType.Estimated);
        p.setStde(err);
        if (err == 0.0) {
            return ParameterInfo.of(p);
        }
        int nhp = 0;
        if (source.pcov_ != null) {
            nhp = source.pcov_.diagonal().count(x -> x > 0.0);
        }
        int df = source.likelihood_.getDegreesOfFreedom(true, nhp);
        T t = new T();
        t.setDegreesofFreedom(df);
        double tval = p.getValue() / err;
        double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
        return new ParameterInfo(p, prob, null);
    }

    static {
        MAPPING.set(InformationSet.item(LIKELIHOOD, NEFFOBS), Integer.class, source -> source.statistics_.effectiveObservationsCount);
        MAPPING.set(InformationSet.item(LIKELIHOOD, NP), Integer.class, source -> source.statistics_.estimatedParametersCount);
        MAPPING.set(InformationSet.item(LIKELIHOOD, LVAL), Double.class, source -> source.statistics_.logLikelihood);
        MAPPING.set(InformationSet.item(LIKELIHOOD, ADJLVAL), Double.class, source -> source.statistics_.adjustedLogLikelihood);
        MAPPING.set(InformationSet.item(LIKELIHOOD, SSQERR), Double.class, source -> source.statistics_.SsqErr);
        MAPPING.set(InformationSet.item(LIKELIHOOD, AIC), Double.class, source -> source.statistics_.AIC);
        MAPPING.set(InformationSet.item(LIKELIHOOD, AICC), Double.class, source -> source.statistics_.AICC);
        MAPPING.set(InformationSet.item(LIKELIHOOD, BIC), Double.class, source -> source.statistics_.BIC);
        MAPPING.set(InformationSet.item(LIKELIHOOD, BICC), Double.class, source -> source.statistics_.BICC);
        MAPPING.set(InformationSet.item(RESIDUALS, SER), Double.class, source -> Math.sqrt(source.statistics_.SsqErr / (double)(source.statistics_.effectiveObservationsCount - source.statistics_.estimatedParametersCount + 1)));
        MAPPING.set(InformationSet.item(RESIDUALS, SERML), Double.class, source -> Math.sqrt(source.statistics_.SsqErr / (double)source.statistics_.effectiveObservationsCount));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_DATA), double[].class, source -> source.likelihood_.getResiduals());
        MAPPING.set(InformationSet.item(RESIDUALS, "mean"), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getMeanTest()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_SKEWNESS), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getSkewness()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_KURTOSIS), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getKurtosis()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_DH), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getNormalityTest()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_LB), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getLjungBox()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_LB2), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getLjungBoxOnSquare()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_SEASLB), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getSeasonalLjungBox()));
        MAPPING.set(InformationSet.item(RESIDUALS, "bp"), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getBoxPierce()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_BP2), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getBoxPierceOnSquare()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_SEASBP), StatisticalTest.class, source -> StatisticalTest.of(source.getNiidTests().getSeasonalBoxPierce()));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_UD_NUMBER), StatisticalTest.class, source -> {
            TestofUpDownRuns ud = source.getNiidTests().getUpAndDownRuns();
            if (ud == null) {
                return null;
            }
            ud.setKind(RunsTestKind.Number);
            return StatisticalTest.of(ud);
        });
        MAPPING.set(InformationSet.item(RESIDUALS, RES_UD_LENGTH), StatisticalTest.class, source -> {
            TestofUpDownRuns ud = source.getNiidTests().getUpAndDownRuns();
            if (ud == null) {
                return null;
            }
            ud.setKind(RunsTestKind.Length);
            return StatisticalTest.of(ud);
        });
        MAPPING.set(InformationSet.item(RESIDUALS, RES_RUNS_NUMBER), StatisticalTest.class, source -> {
            TestofRuns runs = source.getNiidTests().getRuns();
            if (runs == null) {
                return null;
            }
            runs.setKind(RunsTestKind.Number);
            return StatisticalTest.of(runs);
        });
        MAPPING.set(InformationSet.item(RESIDUALS, RES_RUNS_LENGTH), StatisticalTest.class, source -> {
            TestofRuns runs = source.getNiidTests().getRuns();
            if (runs == null) {
                return null;
            }
            runs.setKind(RunsTestKind.Length);
            return StatisticalTest.of(runs);
        });
        MAPPING.set(ARIMA, SarimaModel.class, source -> source.model_.getArima());
        MAPPING.set(InformationSet.item(ARIMA, "mean"), Boolean.class, source -> source.model_.isMeanCorrection());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_P), Integer.class, source -> source.model_.getArima().getRegularAROrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_D), Integer.class, source -> source.model_.getArima().getRegularDifferenceOrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_Q), Integer.class, source -> source.model_.getArima().getRegularMAOrder());
        MAPPING.set(InformationSet.item(ARIMA, "bp"), Integer.class, source -> source.model_.getArima().getSeasonalAROrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_BD), Integer.class, source -> source.model_.getArima().getSeasonalDifferenceOrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_BQ), Integer.class, source -> source.model_.getArima().getSeasonalMAOrder());
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_PHI), 1, 5, ParameterInfo.class, (source, i) -> ModelEstimation.param(source, ARIMA_PHI, i));
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_BPHI), 1, 2, ParameterInfo.class, (source, i) -> ModelEstimation.param(source, ARIMA_BPHI, i));
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_TH), 1, 5, ParameterInfo.class, (source, i) -> ModelEstimation.param(source, ARIMA_TH, i));
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_BTH), 1, 2, ParameterInfo.class, (source, i) -> ModelEstimation.param(source, ARIMA_BTH, i));
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_COVAR), Matrix.class, source -> source.pcov_);
    }
}

