/*
 * Decompiled with CFR 0.152.
 */
package demetra.information;

import demetra.information.InformationExtractors;
import ec.tstoolkit.utilities.WildCards;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface InformationExtractor<S> {
    public static final char SEP = '.';
    public static final String STRSEP = new String(new char[]{'.'});

    public static String concatenate(String ... s) {
        switch (s.length) {
            case 0: {
                return "";
            }
            case 1: {
                return s[0];
            }
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            if (!first) {
                builder.append('.');
            } else {
                first = false;
            }
            builder.append(s[i]);
        }
        return builder.toString();
    }

    public void fillDictionary(String var1, Map<String, Class> var2, boolean var3);

    public boolean contains(String var1);

    public <T> T getData(S var1, String var2, Class<T> var3);

    public <T> void searchAll(S var1, WildCards var2, Class<T> var3, Map<String, T> var4);

    public static <S, Q> InformationExtractor<S> extractor(String name, Class<Q> targetClass, Function<S, Q> fn) {
        return new InformationExtractors.AtomicExtractor<S>(name, targetClass, fn);
    }

    public static <S, Q> InformationExtractor<S> delegate(String name, InformationExtractor<Q> extractor, Function<S, Q> fn) {
        return new InformationExtractors.ExtractorDelegate<S, Q>(name, extractor, fn);
    }

    public static <S, Q> InformationExtractor<S> delegateArray(String name, int start, int end, InformationExtractor<Q> extractor, BiFunction<S, Integer, Q> fn) {
        return new InformationExtractors.ArrayExtractorDelegate<S, Q>(name, start, end, extractor, fn);
    }

    public static <S, Q> InformationExtractor<S> array(String name, int start, int end, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        return new InformationExtractors.ArrayExtractor<S>(name, start, end, targetClass, fn);
    }

    public static <S, Q> InformationExtractor<S> array(String name, int defparam, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        return new InformationExtractors.ArrayExtractor<S>(name, defparam, defparam, targetClass, fn);
    }
}

