/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.NumConstants;
import ec.tstoolkit.dstats.ProbabilityType;

public final class Utility {
    private static final double[] m_a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
    private static final double[] m_b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
    private static final double[] m_c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
    private static final double[] m_d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
    private static final double[] m_p = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
    private static final double[] m_q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
    private static final double[] s_xnum = new double[]{-0.322232431088, -1.0, -0.342242088547, -0.0204231210245, -4.53642210148E-5};
    private static final double[] s_xden = new double[]{0.099348462606, 0.588581570495, 0.531103462366, 0.10353775285, 0.0038560700634};
    private static final int m_maxit = 200;

    static double calcPoly(double[] coeff, double val) {
        double term = coeff[coeff.length - 1];
        for (int i = coeff.length - 2; i >= 0; --i) {
            term = coeff[i] + term * val;
        }
        return term;
    }

    static double calcPoly(double[] coeff, int leng, double val) {
        double term = coeff[leng - 1];
        for (int i = leng - 2; i >= 0; --i) {
            term = coeff[i] + term * val;
        }
        return term;
    }

    static double intProbability(double x, ProbabilityType pt) {
        double res = 0.0;
        double y = Math.abs(x);
        if (y <= 0.66291) {
            double xsq = 0.0;
            if (y > 0.0) {
                xsq = x * x;
            }
            double xnum = m_a[4] * xsq;
            double xden = xsq;
            for (int i = 0; i < 3; ++i) {
                xnum = (xnum + m_a[i]) * xsq;
                xden = (xden + m_b[i]) * xsq;
            }
            res = x * (xnum + m_a[3]) / (xden + m_b[3]) + 0.5;
        } else if (y <= NumConstants.ROOT32) {
            double xnum = m_c[8] * y;
            double xden = y;
            for (int i = 0; i < 7; ++i) {
                xnum = (xnum + m_c[i]) * y;
                xden = (xden + m_d[i]) * y;
            }
            double result = (xnum + m_c[7]) / (xden + m_d[7]);
            double xsq = Math.floor(y * 1.6) / 1.6;
            double del = (y - xsq) * (y + xsq);
            result = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * result;
            res = x > 0.0 ? 1.0 - result : result;
        } else {
            double result = 0.0;
            double xsq = 1.0 / (x * x);
            double xnum = m_p[5] * xsq;
            double xden = xsq;
            for (int i = 0; i < 4; ++i) {
                xnum = (xnum + m_p[i]) * xsq;
                xden = (xden + m_q[i]) * xsq;
            }
            result = xsq * (xnum + m_p[4]) / (xden + m_q[4]);
            result = (NumConstants.SQRPI - result) / y;
            xsq = Math.floor(x * 1.6) / 1.6;
            double del = (x - xsq) * (x + xsq);
            result = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * result;
            res = x > 0.0 ? 1.0 - result : result;
        }
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    static double intProbabilityInverse(double p, calcProbDelegate cb) {
        double strtx;
        double eps = 1.0E-13;
        double pp = 1.0 - p;
        if (p <= 0.5) {
            pp = p;
        }
        double xcur = strtx = Utility.stnVal(pp);
        for (int i = 0; i < 200; ++i) {
            double res = cb.calcProb(xcur);
            double dx = (res - pp) / (NumConstants.SQRPI * Math.exp(-0.5 * xcur * xcur));
            if (!(Math.abs(dx / (xcur -= dx)) <= eps)) continue;
            if (p > 0.5) {
                return -xcur;
            }
            return xcur;
        }
        throw new DStatException("Too many iterations in search procedure");
    }

    static double stnVal(double p) {
        double sign = 1.0;
        double z = 1.0 - p;
        if (p <= 0.5) {
            sign = -1.0;
            z = p;
        }
        double y = Math.sqrt(-2.0 * Math.log(z));
        return (y + Utility.calcPoly(s_xnum, y) / Utility.calcPoly(s_xden, y)) * sign;
    }

    private Utility() {
    }

    public static interface calcProbDelegate {
        public double calcProb(double var1);
    }
}

