/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingleResult<T>
implements IProcResults {
    final String name;
    final T value;
    final Class<T> tclass;
    public static final String VALUE = "value";

    public SingleResult(String name, T val, Class<T> tclass) {
        this.name = name;
        this.value = val;
        this.tclass = tclass;
    }

    public SingleResult(T val, Class<T> tclass) {
        this.name = VALUE;
        this.value = val;
        this.tclass = tclass;
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    @Override
    public boolean contains(String id) {
        return id.equals(this.name);
    }

    @Override
    public Map<String, Class> getDictionary() {
        return Collections.singletonMap(this.name, this.tclass);
    }

    public <S> S getData(String id, Class<S> tclass) {
        if (this.name.equals(id) && this.tclass.equals(tclass)) {
            return (S)this.value;
        }
        return null;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }
}

