/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.Enumeration;

public class YearIterator
implements Enumeration<TsDataBlock> {
    private TsDataBlock m_cur;
    private final TsDataBlock m_data;

    public static YearIterator fullYears(TsData series) {
        TsDomain domain = series.getDomain();
        int ifreq = domain.getFrequency().intValue();
        int nbeg = series.getStart().getPosition();
        int nend = series.getEnd().getPosition();
        domain = domain.drop(nbeg == 0 ? 0 : ifreq - nbeg, nend);
        return new YearIterator(series, domain);
    }

    public YearIterator(TsData series) {
        this.m_data = !series.isEmpty() ? TsDataBlock.all(series) : null;
    }

    public YearIterator(TsData series, TsDomain domain) {
        this.m_data = TsDataBlock.select(series, domain);
    }

    public YearIterator(TsData series, TsPeriodSelector selector) {
        this.m_data = TsDataBlock.select(series, selector);
    }

    @Override
    public boolean hasMoreElements() {
        if (this.m_data == null) {
            return false;
        }
        if (this.m_cur == null) {
            return true;
        }
        int ifreq = this.m_data.start.getFrequency().intValue();
        int ibeg = this.m_cur.start.minus(this.m_data.start);
        int iend = this.m_data.data.getLength() - ifreq - ibeg;
        return iend > 0;
    }

    private void initialize() {
        int ifreq = this.m_data.start.getFrequency().intValue();
        int beg = this.m_data.start.getPosition();
        this.m_cur = new TsDataBlock(this.m_data.start.minus(beg), this.m_data.data.extract(-beg, ifreq, 1));
    }

    @Override
    public TsDataBlock nextElement() {
        int ifreq = this.m_data.start.getFrequency().intValue();
        if (this.m_cur == null) {
            this.initialize();
        } else {
            this.m_cur.move(ifreq);
        }
        int ibeg = this.m_cur.start.minus(this.m_data.start);
        int iend = this.m_data.data.getLength() - ifreq - ibeg;
        if (ibeg >= 0 && iend >= 0) {
            return this.m_cur;
        }
        return this.m_cur.drop(ibeg < 0 ? -ibeg : 0, iend < 0 ? -iend : 0);
    }

    public void reset() {
        this.m_cur = null;
    }
}

