% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_packages.R
\name{download_packages}
\alias{download_packages}
\title{Download packages}
\usage{
download_packages(app_dir, pkgs_path, pkgs, repo, remotes, auth_user,
  auth_token)
}
\arguments{
\item{app_dir}{Development app's directory, defaults to \code{getwd()}.}

\item{pkgs_path}{Default location inside the app working directory to install package dependencies This defaults to \code{pkgs_path = "bin"}}

\item{pkgs}{Character vector of package dependencies. Remote development versions are supported via \code{remotes}. \code{pkgs} are downloaded into \code{file.path(app_dir, pkgs_path)} as Windows binary packages (.zip). If you build binary packages and store them there before calling \code{create_app}, they will be included as well.}

\item{repo}{Default repository to install CRAN package dependencies. Defaults to \code{repo = "https://cran.rstudio.com"}.}

\item{remotes}{Character vector of GitHub repository addresses in the format \code{username/repo[/subdir][\@ref|#pull]} for GitHub package dependencies.}

\item{auth_user}{Bitbucket username. It is recommended to create a read-only account for each app.  Support for OAuth 2 and tokens is in the works.}

\item{auth_token}{To install from a private Github repo, generate a personal access token (PAT) in \url{https://github.com/settings/tokens} and supply to this argument. This is safer than using a password because you can easily delete a PAT without affecting any others.}
}
\description{
Places package dependencies in \code{pkgs_path}.
}
