% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_section.R
\name{run_section}
\alias{run_section}
\title{Run Section of ISS}
\usage{
run_section(iss, R_flags = "/SILENT")
}
\arguments{
\item{iss}{Character vector which cumulatively becomes an Inno Setup Script (ISS).}

\item{R_flags}{String of flags to customize R's installation. Defaults to "/SILENT". For other options, visit \href{https://cran.r-project.org/bin/windows/base/rw-FAQ.html#Can-I-customize-the-installation_003f}{Section 2.4} of the R FAQ. If using the '/DIR=""C:\\myapp""' flag, use double backslashes and double quotes. For more information on valid Inno Setup constants, see the \href{http://www.jrsoftware.org/ishelp/index.php?topic=consts}{Constants} section.}
}
\value{
Chainable character vector, which can be used as the \code{text} argument of \code{\link{writeLines}} to generate an ISS.
}
\description{
Specifies any number of programs to execute after the program has been successfully installed, but before the installer displays the final dialog. See \href{http://www.jrsoftware.org/ishelp/topic_runsection.htm}{[Run]} for details.
}
\examples{
\dontrun{
# You can combine custom R installation flags with Inno Setup constants
create_app("myapp", "app", R_flags = '/SILENT /DIR=""{userdocs}""')

# Or directly
run_section(iss, R_flags = '/SILENT /DIR=""{userdocs}""')

}


}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives_section}}, \code{\link{setup_section}}, \code{\link{languages_section}}, \code{\link{tasks_section}}, \code{\link{files_section}}, \code{\link{icons_section}}, \code{\link{run_section}}, and \code{\link{code_section}}.
}
\author{
Jonathan M. Hill
}
